/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import org.ta4j.core.Rule;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;

public interface Strategy {
    public String getName();

    public Rule getEntryRule();

    public Rule getExitRule();

    public Strategy and(Strategy var1);

    public Strategy or(Strategy var1);

    public Strategy and(String var1, Strategy var2, int var3);

    public Strategy or(String var1, Strategy var2, int var3);

    public Strategy opposite();

    public void setUnstablePeriod(int var1);

    public int getUnstablePeriod();

    public boolean isUnstableAt(int var1);

    default public boolean shouldOperate(int index, TradingRecord tradingRecord) {
        Trade trade = tradingRecord.getCurrentTrade();
        if (trade.isNew()) {
            return this.shouldEnter(index, tradingRecord);
        }
        if (trade.isOpened()) {
            return this.shouldExit(index, tradingRecord);
        }
        return false;
    }

    default public boolean shouldEnter(int index) {
        return this.shouldEnter(index, null);
    }

    default public boolean shouldEnter(int index, TradingRecord tradingRecord) {
        return !this.isUnstableAt(index) && this.getEntryRule().isSatisfied(index, tradingRecord);
    }

    default public boolean shouldExit(int index) {
        return this.shouldExit(index, null);
    }

    default public boolean shouldExit(int index, TradingRecord tradingRecord) {
        return !this.isUnstableAt(index) && this.getExitRule().isSatisfied(index, tradingRecord);
    }
}

