/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import java.io.Serializable;
import java.util.Objects;
import org.ta4j.core.BarSeries;
import org.ta4j.core.cost.CostModel;
import org.ta4j.core.cost.ZeroCostModel;
import org.ta4j.core.num.Num;

public class Order
implements Serializable {
    private static final long serialVersionUID = -905474949010114150L;
    private OrderType type;
    private int index;
    private Num pricePerAsset;
    private Num netPrice;
    private Num amount;
    private Num cost;
    private CostModel costModel;

    protected Order(int index, BarSeries series, OrderType type) {
        this(index, series, type, series.numOf(1));
    }

    protected Order(int index, BarSeries series, OrderType type, Num amount) {
        this(index, series, type, amount, (CostModel)new ZeroCostModel());
    }

    protected Order(int index, BarSeries series, OrderType type, Num amount, CostModel transactionCostModel) {
        this.type = type;
        this.index = index;
        this.amount = amount;
        this.setPricesAndCost(series.getBar(index).getClosePrice(), amount, transactionCostModel);
    }

    protected Order(int index, OrderType type, Num pricePerAsset) {
        this(index, type, pricePerAsset, pricePerAsset.numOf(1));
    }

    protected Order(int index, OrderType type, Num pricePerAsset, Num amount) {
        this(index, type, pricePerAsset, amount, (CostModel)new ZeroCostModel());
    }

    protected Order(int index, OrderType type, Num pricePerAsset, Num amount, CostModel transactionCostModel) {
        this.type = type;
        this.index = index;
        this.amount = amount;
        this.setPricesAndCost(pricePerAsset, amount, transactionCostModel);
    }

    public OrderType getType() {
        return this.type;
    }

    public Num getCost() {
        return this.cost;
    }

    public int getIndex() {
        return this.index;
    }

    public Num getPricePerAsset() {
        return this.pricePerAsset;
    }

    public Num getNetPrice() {
        return this.netPrice;
    }

    public Num getAmount() {
        return this.amount;
    }

    public CostModel getCostModel() {
        return this.costModel;
    }

    private void setPricesAndCost(Num pricePerAsset, Num amount, CostModel transactionCostModel) {
        this.costModel = transactionCostModel;
        this.pricePerAsset = pricePerAsset;
        this.cost = transactionCostModel.calculate(this.pricePerAsset, amount);
        Num costPerAsset = this.cost.dividedBy(amount);
        this.netPrice = this.type.equals((Object)OrderType.BUY) ? this.pricePerAsset.plus(costPerAsset) : this.pricePerAsset.minus(costPerAsset);
    }

    public boolean isBuy() {
        return this.type == OrderType.BUY;
    }

    public boolean isSell() {
        return this.type == OrderType.SELL;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.index, this.pricePerAsset, this.amount});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.index, other.index) && Objects.equals(this.pricePerAsset, other.pricePerAsset) && Objects.equals(this.amount, other.amount);
    }

    public String toString() {
        return "Order{type=" + (Object)((Object)this.type) + ", index=" + this.index + ", price=" + this.pricePerAsset + ", amount=" + this.amount + '}';
    }

    public static Order buyAt(int index, BarSeries series) {
        return new Order(index, series, OrderType.BUY);
    }

    public static Order buyAt(int index, Num price, Num amount, CostModel transactionCostModel) {
        return new Order(index, OrderType.BUY, price, amount, transactionCostModel);
    }

    public static Order buyAt(int index, Num price, Num amount) {
        return new Order(index, OrderType.BUY, price, amount);
    }

    public static Order buyAt(int index, BarSeries series, Num amount) {
        return new Order(index, series, OrderType.BUY, amount);
    }

    public static Order buyAt(int index, BarSeries series, Num amount, CostModel transactionCostModel) {
        return new Order(index, series, OrderType.BUY, amount, transactionCostModel);
    }

    public static Order sellAt(int index, BarSeries series) {
        return new Order(index, series, OrderType.SELL);
    }

    public static Order sellAt(int index, Num price, Num amount) {
        return new Order(index, OrderType.SELL, price, amount);
    }

    public static Order sellAt(int index, Num price, Num amount, CostModel transactionCostModel) {
        return new Order(index, OrderType.SELL, price, amount, transactionCostModel);
    }

    public static Order sellAt(int index, BarSeries series, Num amount) {
        return new Order(index, series, OrderType.SELL, amount);
    }

    public static Order sellAt(int index, BarSeries series, Num amount, CostModel transactionCostModel) {
        return new Order(index, series, OrderType.SELL, amount, transactionCostModel);
    }

    public Num getValue() {
        return this.pricePerAsset.multipliedBy(this.amount);
    }

    public static enum OrderType {
        BUY{

            @Override
            public OrderType complementType() {
                return SELL;
            }
        }
        ,
        SELL{

            @Override
            public OrderType complementType() {
                return BUY;
            }
        };


        public abstract OrderType complementType();
    }
}

