/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.function.Function;
import org.ta4j.core.BaseBarBuilder;
import org.ta4j.core.num.Num;

public class ConvertibleBaseBarBuilder<T>
extends BaseBarBuilder {
    private final Function<T, Num> conversionFunction;

    public ConvertibleBaseBarBuilder(Function<T, Num> conversionFunction) {
        this.conversionFunction = conversionFunction;
    }

    @Override
    public ConvertibleBaseBarBuilder<T> timePeriod(Duration timePeriod) {
        super.timePeriod(timePeriod);
        return this;
    }

    @Override
    public ConvertibleBaseBarBuilder<T> endTime(ZonedDateTime endTime) {
        super.endTime(endTime);
        return this;
    }

    @Override
    public ConvertibleBaseBarBuilder<T> trades(int trades) {
        super.trades(trades);
        return this;
    }

    public ConvertibleBaseBarBuilder<T> openPrice(T openPrice) {
        super.openPrice(this.conversionFunction.apply(openPrice));
        return this;
    }

    public ConvertibleBaseBarBuilder<T> highPrice(T highPrice) {
        super.highPrice(this.conversionFunction.apply(highPrice));
        return this;
    }

    public ConvertibleBaseBarBuilder<T> lowPrice(T lowPrice) {
        super.lowPrice(this.conversionFunction.apply(lowPrice));
        return this;
    }

    public ConvertibleBaseBarBuilder<T> closePrice(T closePrice) {
        super.closePrice(this.conversionFunction.apply(closePrice));
        return this;
    }

    public ConvertibleBaseBarBuilder<T> amount(T amount) {
        super.amount(this.conversionFunction.apply(amount));
        return this;
    }

    public ConvertibleBaseBarBuilder<T> volume(T volume) {
        super.volume(this.conversionFunction.apply(volume));
        return this;
    }
}

