/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ta4j.core.Rule;
import org.ta4j.core.Strategy;
import org.ta4j.core.TradingRecord;

public class BaseStrategy
implements Strategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String className = this.getClass().getSimpleName();
    private String name;
    private Rule entryRule;
    private Rule exitRule;
    private int unstablePeriod;

    public BaseStrategy(Rule entryRule, Rule exitRule) {
        this(null, entryRule, exitRule, 0);
    }

    public BaseStrategy(Rule entryRule, Rule exitRule, int unstablePeriod) {
        this(null, entryRule, exitRule, unstablePeriod);
    }

    public BaseStrategy(String name, Rule entryRule, Rule exitRule) {
        this(name, entryRule, exitRule, 0);
    }

    public BaseStrategy(String name, Rule entryRule, Rule exitRule, int unstablePeriod) {
        if (entryRule == null || exitRule == null) {
            throw new IllegalArgumentException("Rules cannot be null");
        }
        if (unstablePeriod < 0) {
            throw new IllegalArgumentException("Unstable period bar count must be >= 0");
        }
        this.name = name;
        this.entryRule = entryRule;
        this.exitRule = exitRule;
        this.unstablePeriod = unstablePeriod;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Rule getEntryRule() {
        return this.entryRule;
    }

    @Override
    public Rule getExitRule() {
        return this.exitRule;
    }

    @Override
    public int getUnstablePeriod() {
        return this.unstablePeriod;
    }

    @Override
    public void setUnstablePeriod(int unstablePeriod) {
        this.unstablePeriod = unstablePeriod;
    }

    @Override
    public boolean isUnstableAt(int index) {
        return index < this.unstablePeriod;
    }

    @Override
    public boolean shouldEnter(int index, TradingRecord tradingRecord) {
        boolean enter = Strategy.super.shouldEnter(index, tradingRecord);
        this.traceShouldEnter(index, enter);
        return enter;
    }

    @Override
    public boolean shouldExit(int index, TradingRecord tradingRecord) {
        boolean exit = Strategy.super.shouldExit(index, tradingRecord);
        this.traceShouldExit(index, exit);
        return exit;
    }

    @Override
    public Strategy and(Strategy strategy) {
        String andName = "and(" + this.name + "," + strategy.getName() + ")";
        int unstable = Math.max(this.unstablePeriod, strategy.getUnstablePeriod());
        return this.and(andName, strategy, unstable);
    }

    @Override
    public Strategy or(Strategy strategy) {
        String orName = "or(" + this.name + "," + strategy.getName() + ")";
        int unstable = Math.max(this.unstablePeriod, strategy.getUnstablePeriod());
        return this.or(orName, strategy, unstable);
    }

    @Override
    public Strategy opposite() {
        return new BaseStrategy("opposite(" + this.name + ")", this.exitRule, this.entryRule, this.unstablePeriod);
    }

    @Override
    public Strategy and(String name, Strategy strategy, int unstablePeriod) {
        return new BaseStrategy(name, this.entryRule.and(strategy.getEntryRule()), this.exitRule.and(strategy.getExitRule()), unstablePeriod);
    }

    @Override
    public Strategy or(String name, Strategy strategy, int unstablePeriod) {
        return new BaseStrategy(name, this.entryRule.or(strategy.getEntryRule()), this.exitRule.or(strategy.getExitRule()), unstablePeriod);
    }

    protected void traceShouldEnter(int index, boolean enter) {
        this.log.trace(">>> {}#shouldEnter({}): {}", new Object[]{this.className, index, enter});
    }

    protected void traceShouldExit(int index, boolean exit) {
        this.log.trace(">>> {}#shouldExit({}): {}", new Object[]{this.className, index, exit});
    }
}

