/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.ta4j.core.Bar;
import org.ta4j.core.BarSeriesBuilder;
import org.ta4j.core.BaseBarSeries;
import org.ta4j.core.num.DoubleNum;
import org.ta4j.core.num.Num;
import org.ta4j.core.num.PrecisionNum;

public class BaseBarSeriesBuilder
implements BarSeriesBuilder {
    private static final long serialVersionUID = 111164611841087550L;
    private static Function<Number, Num> defaultFunction = PrecisionNum::valueOf;
    private List<Bar> bars;
    private String name;
    private Function<Number, Num> numFunction;
    private boolean constrained;
    private int maxBarCount;

    public BaseBarSeriesBuilder() {
        this.initValues();
    }

    public static void setDefaultFunction(Function<Number, Num> defaultFunction) {
        BaseBarSeriesBuilder.defaultFunction = defaultFunction;
    }

    private void initValues() {
        this.bars = new ArrayList<Bar>();
        this.name = "unnamed_series";
        this.numFunction = defaultFunction;
        this.constrained = false;
        this.maxBarCount = Integer.MAX_VALUE;
    }

    @Override
    public BaseBarSeries build() {
        int beginIndex = -1;
        int endIndex = -1;
        if (!this.bars.isEmpty()) {
            beginIndex = 0;
            endIndex = this.bars.size() - 1;
        }
        BaseBarSeries series = new BaseBarSeries(this.name, this.bars, beginIndex, endIndex, this.constrained, this.numFunction);
        series.setMaximumBarCount(this.maxBarCount);
        this.initValues();
        return series;
    }

    public BaseBarSeriesBuilder setConstrained(boolean constrained) {
        this.constrained = constrained;
        return this;
    }

    public BaseBarSeriesBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public BaseBarSeriesBuilder withBars(List<Bar> bars) {
        this.bars = bars;
        return this;
    }

    public BaseBarSeriesBuilder withMaxBarCount(int maxBarCount) {
        this.maxBarCount = maxBarCount;
        return this;
    }

    public BaseBarSeriesBuilder withNumTypeOf(Num type) {
        this.numFunction = type.function();
        return this;
    }

    public BaseBarSeriesBuilder withNumTypeOf(Function<Number, Num> function) {
        this.numFunction = function;
        return this;
    }

    public BaseBarSeriesBuilder withNumTypeOf(Class<? extends Num> abstractNumClass) {
        if (abstractNumClass == PrecisionNum.class) {
            this.numFunction = PrecisionNum::valueOf;
            return this;
        }
        if (abstractNumClass == DoubleNum.class) {
            this.numFunction = DoubleNum::valueOf;
            return this;
        }
        this.numFunction = PrecisionNum::valueOf;
        return this;
    }
}

