/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ta4j.core.Bar;
import org.ta4j.core.BarSeries;
import org.ta4j.core.BaseBar;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;
import org.ta4j.core.num.PrecisionNum;

public class BaseBarSeries
implements BarSeries {
    private static final long serialVersionUID = -1878027009398790126L;
    private static final String UNNAMED_SERIES_NAME = "unnamed_series";
    protected final Function<Number, Num> numFunction;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private final List<Bar> bars;
    private int seriesBeginIndex;
    private int seriesEndIndex;
    private int maximumBarCount = Integer.MAX_VALUE;
    private int removedBarsCount = 0;
    private boolean constrained;

    public BaseBarSeries() {
        this(UNNAMED_SERIES_NAME);
    }

    public BaseBarSeries(String name) {
        this(name, new ArrayList<Bar>());
    }

    public BaseBarSeries(List<Bar> bars) {
        this(UNNAMED_SERIES_NAME, bars);
    }

    public BaseBarSeries(String name, List<Bar> bars) {
        this(name, bars, 0, bars.size() - 1, false);
    }

    public BaseBarSeries(String name, Function<Number, Num> numFunction) {
        this(name, new ArrayList<Bar>(), numFunction);
    }

    public BaseBarSeries(String name, List<Bar> bars, Function<Number, Num> numFunction) {
        this(name, bars, 0, bars.size() - 1, false, numFunction);
    }

    private BaseBarSeries(String name, List<Bar> bars, int seriesBeginIndex, int seriesEndIndex, boolean constrained) {
        this(name, bars, seriesBeginIndex, seriesEndIndex, constrained, PrecisionNum::valueOf);
    }

    BaseBarSeries(String name, List<Bar> bars, int seriesBeginIndex, int seriesEndIndex, boolean constrained, Function<Number, Num> numFunction) {
        this.name = name;
        this.bars = bars;
        if (bars.isEmpty()) {
            this.seriesBeginIndex = -1;
            this.seriesEndIndex = -1;
            this.constrained = false;
            this.numFunction = numFunction;
            return;
        }
        this.numFunction = bars.get(0).getClosePrice().function();
        if (!this.checkBars(bars)) {
            throw new IllegalArgumentException(String.format("Num implementation of bars: %s does not match to Num implementation of bar series: %s", bars.get(0).getClosePrice().getClass(), numFunction));
        }
        if (seriesEndIndex < seriesBeginIndex - 1) {
            throw new IllegalArgumentException("End index must be >= to begin index - 1");
        }
        if (seriesEndIndex >= bars.size()) {
            throw new IllegalArgumentException("End index must be < to the bar list size");
        }
        this.seriesBeginIndex = seriesBeginIndex;
        this.seriesEndIndex = seriesEndIndex;
        this.constrained = constrained;
    }

    private static List<Bar> cut(List<Bar> bars, int startIndex, int endIndex) {
        return new ArrayList<Bar>(bars.subList(startIndex, endIndex));
    }

    private static String buildOutOfBoundsMessage(BaseBarSeries series, int index) {
        return String.format("Size of series: %s bars, %s bars removed, index = %s", series.bars.size(), series.removedBarsCount, index);
    }

    @Override
    public BaseBarSeries getSubSeries(int startIndex, int endIndex) {
        if (startIndex < 0) {
            throw new IllegalArgumentException(String.format("the startIndex: %s must not be negative", startIndex));
        }
        if (startIndex >= endIndex) {
            throw new IllegalArgumentException(String.format("the endIndex: %s must be greater than startIndex: %s", endIndex, startIndex));
        }
        if (!this.bars.isEmpty()) {
            int start = Math.max(startIndex - this.getRemovedBarsCount(), this.getBeginIndex());
            int end = Math.min(endIndex - this.getRemovedBarsCount(), this.getEndIndex() + 1);
            return new BaseBarSeries(this.getName(), BaseBarSeries.cut(this.bars, start, end), this.numFunction);
        }
        return new BaseBarSeries(this.name, this.numFunction);
    }

    @Override
    public Num numOf(Number number) {
        return this.numFunction.apply(number);
    }

    @Override
    public Function<Number, Num> function() {
        return this.numFunction;
    }

    private boolean checkBars(List<Bar> bars) {
        for (Bar bar : bars) {
            if (this.checkBar(bar)) continue;
            return false;
        }
        return true;
    }

    private boolean checkBar(Bar bar) {
        if (bar.getClosePrice() == null) {
            return true;
        }
        Class<?> f = this.numOf(1).getClass();
        return f == bar.getClosePrice().getClass() || bar.getClosePrice().equals(NaN.NaN);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Bar getBar(int i) {
        int innerIndex = i - this.removedBarsCount;
        if (innerIndex < 0) {
            if (i < 0) {
                throw new IndexOutOfBoundsException(BaseBarSeries.buildOutOfBoundsMessage(this, i));
            }
            this.log.trace("Bar series `{}` ({} bars): bar {} already removed, use {}-th instead", new Object[]{this.name, this.bars.size(), i, this.removedBarsCount});
            if (this.bars.isEmpty()) {
                throw new IndexOutOfBoundsException(BaseBarSeries.buildOutOfBoundsMessage(this, this.removedBarsCount));
            }
            innerIndex = 0;
        } else if (innerIndex >= this.bars.size()) {
            throw new IndexOutOfBoundsException(BaseBarSeries.buildOutOfBoundsMessage(this, i));
        }
        return this.bars.get(innerIndex);
    }

    @Override
    public int getBarCount() {
        if (this.seriesEndIndex < 0) {
            return 0;
        }
        int startIndex = Math.max(this.removedBarsCount, this.seriesBeginIndex);
        return this.seriesEndIndex - startIndex + 1;
    }

    @Override
    public List<Bar> getBarData() {
        return this.bars;
    }

    @Override
    public int getBeginIndex() {
        return this.seriesBeginIndex;
    }

    @Override
    public int getEndIndex() {
        return this.seriesEndIndex;
    }

    @Override
    public int getMaximumBarCount() {
        return this.maximumBarCount;
    }

    @Override
    public void setMaximumBarCount(int maximumBarCount) {
        if (this.constrained) {
            throw new IllegalStateException("Cannot set a maximum bar count on a constrained bar series");
        }
        if (maximumBarCount <= 0) {
            throw new IllegalArgumentException("Maximum bar count must be strictly positive");
        }
        this.maximumBarCount = maximumBarCount;
        this.removeExceedingBars();
    }

    @Override
    public int getRemovedBarsCount() {
        return this.removedBarsCount;
    }

    @Override
    public void addBar(Bar bar, boolean replace) {
        Objects.requireNonNull(bar);
        if (!this.checkBar(bar)) {
            throw new IllegalArgumentException(String.format("Cannot add Bar with data type: %s to series with datatype: %s", bar.getClosePrice().getClass(), this.numOf(1).getClass()));
        }
        if (!this.bars.isEmpty()) {
            if (replace) {
                this.bars.set(this.bars.size() - 1, bar);
                return;
            }
            int lastBarIndex = this.bars.size() - 1;
            ZonedDateTime seriesEndTime = this.bars.get(lastBarIndex).getEndTime();
            if (!bar.getEndTime().isAfter(seriesEndTime)) {
                throw new IllegalArgumentException(String.format("Cannot add a bar with end time:%s that is <= to series end time: %s", bar.getEndTime(), seriesEndTime));
            }
        }
        this.bars.add(bar);
        if (this.seriesBeginIndex == -1) {
            this.seriesBeginIndex = 0;
        }
        ++this.seriesEndIndex;
        this.removeExceedingBars();
    }

    @Override
    public void addBar(Duration timePeriod, ZonedDateTime endTime) {
        this.addBar(new BaseBar(timePeriod, endTime, this.function()));
    }

    @Override
    public void addBar(ZonedDateTime endTime, Num openPrice, Num highPrice, Num lowPrice, Num closePrice, Num volume) {
        this.addBar(new BaseBar(Duration.ofDays(1L), endTime, openPrice, highPrice, lowPrice, closePrice, volume, this.numOf(0)));
    }

    @Override
    public void addBar(ZonedDateTime endTime, Num openPrice, Num highPrice, Num lowPrice, Num closePrice, Num volume, Num amount) {
        this.addBar(new BaseBar(Duration.ofDays(1L), endTime, openPrice, highPrice, lowPrice, closePrice, volume, amount));
    }

    @Override
    public void addBar(Duration timePeriod, ZonedDateTime endTime, Num openPrice, Num highPrice, Num lowPrice, Num closePrice, Num volume) {
        this.addBar(new BaseBar(timePeriod, endTime, openPrice, highPrice, lowPrice, closePrice, volume, this.numOf(0)));
    }

    @Override
    public void addBar(Duration timePeriod, ZonedDateTime endTime, Num openPrice, Num highPrice, Num lowPrice, Num closePrice, Num volume, Num amount) {
        this.addBar(new BaseBar(timePeriod, endTime, openPrice, highPrice, lowPrice, closePrice, volume, amount));
    }

    @Override
    public void addTrade(Number price, Number amount) {
        this.addTrade(this.numOf(price), this.numOf(amount));
    }

    @Override
    public void addTrade(String price, String amount) {
        this.addTrade(this.numOf(new BigDecimal(price)), this.numOf(new BigDecimal(amount)));
    }

    @Override
    public void addTrade(Num tradeVolume, Num tradePrice) {
        this.getLastBar().addTrade(tradeVolume, tradePrice);
    }

    @Override
    public void addPrice(Num price) {
        this.getLastBar().addPrice(price);
    }

    private void removeExceedingBars() {
        int barCount = this.bars.size();
        if (barCount > this.maximumBarCount) {
            int nbBarsToRemove = barCount - this.maximumBarCount;
            for (int i = 0; i < nbBarsToRemove; ++i) {
                this.bars.remove(0);
            }
            this.removedBarsCount += nbBarsToRemove;
        }
    }
}

