/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.function.Function;
import org.ta4j.core.Bar;
import org.ta4j.core.BaseBarBuilder;
import org.ta4j.core.ConvertibleBaseBarBuilder;
import org.ta4j.core.num.DoubleNum;
import org.ta4j.core.num.Num;
import org.ta4j.core.num.PrecisionNum;

public class BaseBar
implements Bar {
    private static final long serialVersionUID = 8038383777467488147L;
    private Duration timePeriod;
    private ZonedDateTime endTime;
    private ZonedDateTime beginTime;
    private Num openPrice = null;
    private Num closePrice = null;
    private Num highPrice = null;
    private Num lowPrice = null;
    private Num amount;
    private Num volume;
    private int trades = 0;

    public BaseBar(Duration timePeriod, ZonedDateTime endTime, Function<Number, Num> numFunction) {
        BaseBar.checkTimeArguments(timePeriod, endTime);
        this.timePeriod = timePeriod;
        this.endTime = endTime;
        this.beginTime = endTime.minus(timePeriod);
        this.volume = numFunction.apply(0);
        this.amount = numFunction.apply(0);
    }

    public BaseBar(Duration timePeriod, ZonedDateTime endTime, double openPrice, double highPrice, double lowPrice, double closePrice, double volume) {
        this(timePeriod, endTime, openPrice, highPrice, lowPrice, closePrice, volume, 0.0);
    }

    public BaseBar(Duration timePeriod, ZonedDateTime endTime, double openPrice, double highPrice, double lowPrice, double closePrice, double volume, double amount) {
        this(timePeriod, endTime, openPrice, highPrice, lowPrice, closePrice, volume, amount, 0, DoubleNum::valueOf);
    }

    public BaseBar(Duration timePeriod, ZonedDateTime endTime, double openPrice, double highPrice, double lowPrice, double closePrice, double volume, double amount, int trades, Function<Number, Num> numFunction) {
        this(timePeriod, endTime, numFunction.apply(openPrice), numFunction.apply(highPrice), numFunction.apply(lowPrice), numFunction.apply(closePrice), numFunction.apply(volume), numFunction.apply(amount), trades);
    }

    public BaseBar(Duration timePeriod, ZonedDateTime endTime, BigDecimal openPrice, BigDecimal highPrice, BigDecimal lowPrice, BigDecimal closePrice, BigDecimal volume) {
        this(timePeriod, endTime, openPrice, highPrice, lowPrice, closePrice, volume, BigDecimal.ZERO);
    }

    public BaseBar(Duration timePeriod, ZonedDateTime endTime, BigDecimal openPrice, BigDecimal highPrice, BigDecimal lowPrice, BigDecimal closePrice, BigDecimal volume, BigDecimal amount) {
        this(timePeriod, endTime, openPrice, highPrice, lowPrice, closePrice, volume, amount, 0, PrecisionNum::valueOf);
    }

    public BaseBar(Duration timePeriod, ZonedDateTime endTime, BigDecimal openPrice, BigDecimal highPrice, BigDecimal lowPrice, BigDecimal closePrice, BigDecimal volume, BigDecimal amount, int trades, Function<Number, Num> numFunction) {
        this(timePeriod, endTime, numFunction.apply(openPrice), numFunction.apply(highPrice), numFunction.apply(lowPrice), numFunction.apply(closePrice), numFunction.apply(volume), numFunction.apply(amount), trades);
    }

    public BaseBar(Duration timePeriod, ZonedDateTime endTime, String openPrice, String highPrice, String lowPrice, String closePrice, String volume) {
        this(timePeriod, endTime, openPrice, highPrice, lowPrice, closePrice, volume, "0");
    }

    public BaseBar(Duration timePeriod, ZonedDateTime endTime, String openPrice, String highPrice, String lowPrice, String closePrice, String volume, String amount) {
        this(timePeriod, endTime, openPrice, highPrice, lowPrice, closePrice, volume, amount, "0", PrecisionNum::valueOf);
    }

    public BaseBar(Duration timePeriod, ZonedDateTime endTime, String openPrice, String highPrice, String lowPrice, String closePrice, String volume, String amount, String trades, Function<Number, Num> numFunction) {
        this(timePeriod, endTime, numFunction.apply(new BigDecimal(openPrice)), numFunction.apply(new BigDecimal(highPrice)), numFunction.apply(new BigDecimal(lowPrice)), numFunction.apply(new BigDecimal(closePrice)), numFunction.apply(new BigDecimal(volume)), numFunction.apply(new BigDecimal(amount)), Integer.valueOf(trades));
    }

    public BaseBar(Duration timePeriod, ZonedDateTime endTime, Num openPrice, Num highPrice, Num lowPrice, Num closePrice, Num volume, Num amount) {
        this(timePeriod, endTime, openPrice, highPrice, lowPrice, closePrice, volume, amount, 0);
    }

    public BaseBar(Duration timePeriod, ZonedDateTime endTime, Num openPrice, Num highPrice, Num lowPrice, Num closePrice, Num volume, Num amount, int trades) {
        BaseBar.checkTimeArguments(timePeriod, endTime);
        this.timePeriod = timePeriod;
        this.endTime = endTime;
        this.beginTime = endTime.minus(timePeriod);
        this.openPrice = openPrice;
        this.highPrice = highPrice;
        this.lowPrice = lowPrice;
        this.closePrice = closePrice;
        this.volume = volume;
        this.amount = amount;
        this.trades = trades;
    }

    public static BaseBarBuilder builder() {
        return new BaseBarBuilder();
    }

    public static <T> ConvertibleBaseBarBuilder<T> builder(Function<T, Num> conversionFunction, Class<T> clazz) {
        return new ConvertibleBaseBarBuilder<T>(conversionFunction);
    }

    @Override
    public Num getOpenPrice() {
        return this.openPrice;
    }

    @Override
    public Num getLowPrice() {
        return this.lowPrice;
    }

    @Override
    public Num getHighPrice() {
        return this.highPrice;
    }

    @Override
    public Num getClosePrice() {
        return this.closePrice;
    }

    @Override
    public Num getVolume() {
        return this.volume;
    }

    @Override
    public int getTrades() {
        return this.trades;
    }

    @Override
    public Num getAmount() {
        return this.amount;
    }

    @Override
    public Duration getTimePeriod() {
        return this.timePeriod;
    }

    @Override
    public ZonedDateTime getBeginTime() {
        return this.beginTime;
    }

    @Override
    public ZonedDateTime getEndTime() {
        return this.endTime;
    }

    @Override
    public void addTrade(Num tradeVolume, Num tradePrice) {
        this.addPrice(tradePrice);
        this.volume = this.volume.plus(tradeVolume);
        this.amount = this.amount.plus(tradeVolume.multipliedBy(tradePrice));
        ++this.trades;
    }

    @Override
    public void addPrice(Num price) {
        if (this.openPrice == null) {
            this.openPrice = price;
        }
        this.closePrice = price;
        if (this.highPrice == null || this.highPrice.isLessThan(price)) {
            this.highPrice = price;
        }
        if (this.lowPrice == null || this.lowPrice.isGreaterThan(price)) {
            this.lowPrice = price;
        }
    }

    public String toString() {
        return String.format("{end time: %1s, close price: %2$f, open price: %3$f, min price: %4$f, max price: %5$f, volume: %6$f}", this.endTime.withZoneSameInstant(ZoneId.systemDefault()), this.closePrice.doubleValue(), this.openPrice.doubleValue(), this.lowPrice.doubleValue(), this.highPrice.doubleValue(), this.volume.doubleValue());
    }

    private static void checkTimeArguments(Duration timePeriod, ZonedDateTime endTime) {
        if (timePeriod == null) {
            throw new IllegalArgumentException("Time period cannot be null");
        }
        if (endTime == null) {
            throw new IllegalArgumentException("End time cannot be null");
        }
    }

    public int hashCode() {
        return Objects.hash(this.beginTime, this.endTime, this.timePeriod, this.openPrice, this.highPrice, this.lowPrice, this.closePrice, this.volume, this.amount, this.trades);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BaseBar)) {
            return false;
        }
        BaseBar other = (BaseBar)obj;
        return Objects.equals(this.beginTime, other.beginTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.timePeriod, other.timePeriod) && Objects.equals(this.openPrice, other.openPrice) && Objects.equals(this.highPrice, other.highPrice) && Objects.equals(this.lowPrice, other.lowPrice) && Objects.equals(this.closePrice, other.closePrice) && Objects.equals(this.volume, other.volume) && Objects.equals(this.amount, other.amount) && this.trades == other.trades;
    }
}

