/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ta4j.core.BarSeries;
import org.ta4j.core.BaseTradingRecord;
import org.ta4j.core.Order;
import org.ta4j.core.Strategy;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.cost.CostModel;
import org.ta4j.core.cost.ZeroCostModel;
import org.ta4j.core.num.Num;

public class BarSeriesManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private BarSeries barSeries;
    private CostModel transactionCostModel;
    private CostModel holdingCostModel;

    public BarSeriesManager() {
        this(null, new ZeroCostModel(), new ZeroCostModel());
    }

    public BarSeriesManager(BarSeries barSeries) {
        this(barSeries, new ZeroCostModel(), new ZeroCostModel());
    }

    public BarSeriesManager(BarSeries barSeries, CostModel transactionCostModel, CostModel holdingCostModel) {
        this.barSeries = barSeries;
        this.transactionCostModel = transactionCostModel;
        this.holdingCostModel = holdingCostModel;
    }

    public void setBarSeries(BarSeries barSeries) {
        this.barSeries = barSeries;
    }

    public BarSeries getBarSeries() {
        return this.barSeries;
    }

    public TradingRecord run(Strategy strategy) {
        return this.run(strategy, Order.OrderType.BUY);
    }

    public TradingRecord run(Strategy strategy, int startIndex, int finishIndex) {
        return this.run(strategy, Order.OrderType.BUY, this.barSeries.numOf(1), startIndex, finishIndex);
    }

    public TradingRecord run(Strategy strategy, Order.OrderType orderType) {
        return this.run(strategy, orderType, this.barSeries.numOf(1));
    }

    public TradingRecord run(Strategy strategy, Order.OrderType orderType, int startIndex, int finishIndex) {
        return this.run(strategy, orderType, this.barSeries.numOf(1), startIndex, finishIndex);
    }

    public TradingRecord run(Strategy strategy, Order.OrderType orderType, Num amount) {
        return this.run(strategy, orderType, amount, this.barSeries.getBeginIndex(), this.barSeries.getEndIndex());
    }

    public TradingRecord run(Strategy strategy, Order.OrderType orderType, Num amount, int startIndex, int finishIndex) {
        int runBeginIndex = Math.max(startIndex, this.barSeries.getBeginIndex());
        int runEndIndex = Math.min(finishIndex, this.barSeries.getEndIndex());
        this.log.trace("Running strategy (indexes: {} -> {}): {} (starting with {})", new Object[]{runBeginIndex, runEndIndex, strategy, orderType});
        BaseTradingRecord tradingRecord = new BaseTradingRecord(orderType, this.transactionCostModel, this.holdingCostModel);
        for (int i = runBeginIndex; i <= runEndIndex; ++i) {
            if (!strategy.shouldOperate(i, tradingRecord)) continue;
            tradingRecord.operate(i, this.barSeries.getBar(i).getClosePrice(), amount);
        }
        if (!tradingRecord.isClosed()) {
            int seriesMaxSize = Math.max(this.barSeries.getEndIndex() + 1, this.barSeries.getBarData().size());
            for (int i = runEndIndex + 1; i < seriesMaxSize; ++i) {
                if (!strategy.shouldOperate(i, tradingRecord)) continue;
                tradingRecord.operate(i, this.barSeries.getBar(i).getClosePrice(), amount);
                break;
            }
        }
        return tradingRecord;
    }
}

