/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.function.Function;
import org.ta4j.core.Bar;
import org.ta4j.core.num.Num;

public interface BarSeries
extends Serializable {
    public String getName();

    public Bar getBar(int var1);

    default public Bar getFirstBar() {
        return this.getBar(this.getBeginIndex());
    }

    default public Bar getLastBar() {
        return this.getBar(this.getEndIndex());
    }

    public int getBarCount();

    default public boolean isEmpty() {
        return this.getBarCount() == 0;
    }

    public List<Bar> getBarData();

    public int getBeginIndex();

    public int getEndIndex();

    default public String getSeriesPeriodDescription() {
        StringBuilder sb = new StringBuilder();
        if (!this.getBarData().isEmpty()) {
            Bar firstBar = this.getFirstBar();
            Bar lastBar = this.getLastBar();
            sb.append(firstBar.getEndTime().format(DateTimeFormatter.ISO_DATE_TIME)).append(" - ").append(lastBar.getEndTime().format(DateTimeFormatter.ISO_DATE_TIME));
        }
        return sb.toString();
    }

    public int getMaximumBarCount();

    public void setMaximumBarCount(int var1);

    public int getRemovedBarsCount();

    default public void addBar(Bar bar) {
        this.addBar(bar, false);
    }

    public void addBar(Bar var1, boolean var2);

    public void addBar(Duration var1, ZonedDateTime var2);

    default public void addBar(ZonedDateTime endTime, Number openPrice, Number highPrice, Number lowPrice, Number closePrice) {
        this.addBar(endTime, this.numOf(openPrice), this.numOf(highPrice), this.numOf(lowPrice), this.numOf(closePrice), this.numOf(0), this.numOf(0));
    }

    default public void addBar(ZonedDateTime endTime, Number openPrice, Number highPrice, Number lowPrice, Number closePrice, Number volume) {
        this.addBar(endTime, this.numOf(openPrice), this.numOf(highPrice), this.numOf(lowPrice), this.numOf(closePrice), this.numOf(volume));
    }

    default public void addBar(ZonedDateTime endTime, Number openPrice, Number highPrice, Number lowPrice, Number closePrice, Number volume, Number amount) {
        this.addBar(endTime, this.numOf(openPrice), this.numOf(highPrice), this.numOf(lowPrice), this.numOf(closePrice), this.numOf(volume), this.numOf(amount));
    }

    default public void addBar(Duration timePeriod, ZonedDateTime endTime, Number openPrice, Number highPrice, Number lowPrice, Number closePrice, Number volume) {
        this.addBar(timePeriod, endTime, this.numOf(openPrice), this.numOf(highPrice), this.numOf(lowPrice), this.numOf(closePrice), this.numOf(volume), this.numOf(0));
    }

    default public void addBar(Duration timePeriod, ZonedDateTime endTime, Number openPrice, Number highPrice, Number lowPrice, Number closePrice, Number volume, Number amount) {
        this.addBar(timePeriod, endTime, this.numOf(openPrice), this.numOf(highPrice), this.numOf(lowPrice), this.numOf(closePrice), this.numOf(volume), this.numOf(amount));
    }

    default public void addBar(ZonedDateTime endTime, String openPrice, String highPrice, String lowPrice, String closePrice) {
        this.addBar(endTime, this.numOf(new BigDecimal(openPrice)), this.numOf(new BigDecimal(highPrice)), this.numOf(new BigDecimal(lowPrice)), this.numOf(new BigDecimal(closePrice)), this.numOf(0), this.numOf(0));
    }

    default public void addBar(ZonedDateTime endTime, String openPrice, String highPrice, String lowPrice, String closePrice, String volume) {
        this.addBar(endTime, this.numOf(new BigDecimal(openPrice)), this.numOf(new BigDecimal(highPrice)), this.numOf(new BigDecimal(lowPrice)), this.numOf(new BigDecimal(closePrice)), this.numOf(new BigDecimal(volume)), this.numOf(0));
    }

    default public void addBar(ZonedDateTime endTime, String openPrice, String highPrice, String lowPrice, String closePrice, String volume, String amount) {
        this.addBar(endTime, this.numOf(new BigDecimal(openPrice)), this.numOf(new BigDecimal(highPrice)), this.numOf(new BigDecimal(lowPrice)), this.numOf(new BigDecimal(closePrice)), this.numOf(new BigDecimal(volume)), this.numOf(new BigDecimal(amount)));
    }

    default public void addBar(ZonedDateTime endTime, Num openPrice, Num highPrice, Num lowPrice, Num closePrice, Num volume) {
        this.addBar(endTime, openPrice, highPrice, lowPrice, closePrice, volume, this.numOf(0));
    }

    public void addBar(ZonedDateTime var1, Num var2, Num var3, Num var4, Num var5, Num var6, Num var7);

    public void addBar(Duration var1, ZonedDateTime var2, Num var3, Num var4, Num var5, Num var6, Num var7);

    public void addBar(Duration var1, ZonedDateTime var2, Num var3, Num var4, Num var5, Num var6, Num var7, Num var8);

    default public void addTrade(Number tradeVolume, Number tradePrice) {
        this.addTrade(this.numOf(tradeVolume), this.numOf(tradePrice));
    }

    default public void addTrade(String tradeVolume, String tradePrice) {
        this.addTrade(this.numOf(new BigDecimal(tradeVolume)), this.numOf(new BigDecimal(tradePrice)));
    }

    public void addTrade(Num var1, Num var2);

    public void addPrice(Num var1);

    default public void addPrice(String price) {
        this.addPrice(new BigDecimal(price));
    }

    default public void addPrice(Number price) {
        this.addPrice(this.numOf(price));
    }

    public BarSeries getSubSeries(int var1, int var2);

    public Num numOf(Number var1);

    public Function<Number, Num> function();
}

