/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import org.ta4j.core.num.Num;

public interface Bar
extends Serializable {
    public Num getOpenPrice();

    public Num getLowPrice();

    public Num getHighPrice();

    public Num getClosePrice();

    public Num getVolume();

    public int getTrades();

    public Num getAmount();

    public Duration getTimePeriod();

    public ZonedDateTime getBeginTime();

    public ZonedDateTime getEndTime();

    default public boolean inPeriod(ZonedDateTime timestamp) {
        return timestamp != null && !timestamp.isBefore(this.getBeginTime()) && timestamp.isBefore(this.getEndTime());
    }

    default public String getDateName() {
        return this.getEndTime().format(DateTimeFormatter.ISO_DATE_TIME);
    }

    default public String getSimpleDateName() {
        return this.getEndTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    default public boolean isBearish() {
        Num openPrice = this.getOpenPrice();
        Num closePrice = this.getClosePrice();
        return openPrice != null && closePrice != null && closePrice.isLessThan(openPrice);
    }

    default public boolean isBullish() {
        Num openPrice = this.getOpenPrice();
        Num closePrice = this.getClosePrice();
        return openPrice != null && closePrice != null && openPrice.isLessThan(closePrice);
    }

    @Deprecated
    default public void addTrade(double tradeVolume, double tradePrice, Function<Number, Num> numFunction) {
        this.addTrade(numFunction.apply(tradeVolume), numFunction.apply(tradePrice));
    }

    @Deprecated
    default public void addTrade(String tradeVolume, String tradePrice, Function<Number, Num> numFunction) {
        this.addTrade(numFunction.apply(new BigDecimal(tradeVolume)), numFunction.apply(new BigDecimal(tradePrice)));
    }

    public void addTrade(Num var1, Num var2);

    default public void addPrice(String price, Function<Number, Num> numFunction) {
        this.addPrice(numFunction.apply(new BigDecimal(price)));
    }

    default public void addPrice(Number price, Function<Number, Num> numFunction) {
        this.addPrice(numFunction.apply(price));
    }

    public void addPrice(Num var1);
}

