/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import java.util.ArrayList;
import java.util.List;
import org.ta4j.core.BarSeries;
import org.ta4j.core.BarSeriesManager;
import org.ta4j.core.Order;
import org.ta4j.core.Strategy;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.num.Num;
import org.ta4j.core.tradereport.TradingStatement;
import org.ta4j.core.tradereport.TradingStatementGenerator;

public class BacktestExecutor {
    private final TradingStatementGenerator tradingStatementGenerator;
    private final BarSeriesManager seriesManager;

    public BacktestExecutor(BarSeries series) {
        this(series, new TradingStatementGenerator());
    }

    public BacktestExecutor(BarSeries series, TradingStatementGenerator tradingStatementGenerator) {
        this.seriesManager = new BarSeriesManager(series);
        this.tradingStatementGenerator = tradingStatementGenerator;
    }

    public List<TradingStatement> execute(List<Strategy> strategies, Num amount) {
        return this.execute(strategies, amount, Order.OrderType.BUY);
    }

    public List<TradingStatement> execute(List<Strategy> strategies, Num amount, Order.OrderType orderType) {
        ArrayList<TradingStatement> tradingStatements = new ArrayList<TradingStatement>(strategies.size());
        for (Strategy strategy : strategies) {
            TradingRecord tradingRecord = this.seriesManager.run(strategy, orderType, amount);
            TradingStatement tradingStatement = this.tradingStatementGenerator.generate(strategy, tradingRecord, this.seriesManager.getBarSeries());
            tradingStatements.add(tradingStatement);
        }
        return tradingStatements;
    }
}

