/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import java.util.List;
import org.ta4j.core.BarSeries;
import org.ta4j.core.BarSeriesManager;
import org.ta4j.core.Strategy;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.num.Num;

public interface AnalysisCriterion {
    public Num calculate(BarSeries var1, Trade var2);

    public Num calculate(BarSeries var1, TradingRecord var2);

    default public Strategy chooseBest(BarSeriesManager manager, List<Strategy> strategies) {
        Strategy bestStrategy = strategies.get(0);
        Num bestCriterionValue = this.calculate(manager.getBarSeries(), manager.run(bestStrategy));
        for (int i = 1; i < strategies.size(); ++i) {
            Strategy currentStrategy = strategies.get(i);
            Num currentCriterionValue = this.calculate(manager.getBarSeries(), manager.run(currentStrategy));
            if (!this.betterThan(currentCriterionValue, bestCriterionValue)) continue;
            bestStrategy = currentStrategy;
            bestCriterionValue = currentCriterionValue;
        }
        return bestStrategy;
    }

    public boolean betterThan(Num var1, Num var2);
}

