/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.graph.node;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.switchyard.HandlerException;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.serial.graph.Graph;
import org.switchyard.serial.graph.node.AccessNode;
import org.switchyard.serial.graph.node.NodeBuilder;

public final class ThrowableAccessNode
extends AccessNode {
    static final Set<String> THROWABLE_IGNORED_ACCESS_NAMES;
    private Integer _clazz;
    private Map<String, Integer> _ids;
    private String _message;
    private Integer _cause;
    private Integer _stackTrace;
    private Boolean _wrapper;

    @Override
    Set<String> getIgnoredAccessNames() {
        return THROWABLE_IGNORED_ACCESS_NAMES;
    }

    @Override
    public Integer getClazz() {
        return this._clazz;
    }

    @Override
    public void setClazz(Integer clazz) {
        this._clazz = clazz;
    }

    @Override
    public Map<String, Integer> getIds() {
        return this._ids;
    }

    @Override
    public void setIds(Map<String, Integer> ids) {
        this._ids = ids;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public Integer getCause() {
        return this._cause;
    }

    public void setCause(Integer cause) {
        this._cause = cause;
    }

    public Integer getStackTrace() {
        return this._stackTrace;
    }

    public void setStackTrace(Integer stackTrace) {
        this._stackTrace = stackTrace;
    }

    public Boolean getWrapper() {
        return this._wrapper;
    }

    public void setWrapper(Boolean wrapper) {
        this._wrapper = wrapper;
    }

    @Override
    public void compose(Object obj, Graph graph) {
        super.compose(obj, graph);
        Throwable throwable = (Throwable)obj;
        this.setMessage(throwable.getMessage());
        this.setCause(NodeBuilder.build(throwable.getCause(), graph));
        this.setStackTrace(NodeBuilder.build(throwable.getStackTrace(), graph));
        if (throwable instanceof HandlerException) {
            this.setWrapper(((HandlerException)throwable).isWrapper());
        }
    }

    @Override
    public Object decompose(Graph graph) {
        Object[] array;
        Throwable throwable = (Throwable)super.decompose(graph);
        Throwable cause = (Throwable)graph.decomposeReference(this.getCause());
        if (cause != null) {
            if (UndeclaredThrowableException.class.equals(throwable.getClass())) {
                Integer referenceId = graph.getReferenceId(throwable);
                throwable = new UndeclaredThrowableException(cause, throwable.getMessage());
                if (referenceId != null) {
                    graph.putReference(referenceId, throwable);
                }
            } else {
                throwable.initCause(cause);
            }
        }
        if ((array = (Object[])graph.decomposeReference(this.getStackTrace())) != null) {
            StackTraceElement[] stackTrace = new StackTraceElement[array.length];
            for (int i = 0; i < array.length; ++i) {
                stackTrace[i] = (StackTraceElement)array[i];
            }
            throwable.setStackTrace(stackTrace);
        }
        if (throwable instanceof HandlerException && this.getWrapper() != null) {
            new FieldAccess(HandlerException.class, "_wrapper").write((Object)throwable, (Object)this.getWrapper());
        }
        return throwable;
    }

    static {
        HashSet<String> throwableIgnoredAccessNames = new HashSet<String>();
        throwableIgnoredAccessNames.addAll(AccessNode.IGNORED_ACCESS_NAMES);
        throwableIgnoredAccessNames.add("message");
        throwableIgnoredAccessNames.add("cause");
        throwableIgnoredAccessNames.add("stackTrace");
        THROWABLE_IGNORED_ACCESS_NAMES = Collections.unmodifiableSet(throwableIgnoredAccessNames);
    }
}

