/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.graph.node;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.switchyard.common.type.reflect.Access;
import org.switchyard.common.type.reflect.BeanAccess;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.common.type.reflect.MethodAccess;
import org.switchyard.serial.SerialLogger;
import org.switchyard.serial.graph.AccessType;
import org.switchyard.serial.graph.CoverageType;
import org.switchyard.serial.graph.Exclude;
import org.switchyard.serial.graph.Factory;
import org.switchyard.serial.graph.Graph;
import org.switchyard.serial.graph.Include;
import org.switchyard.serial.graph.Strategy;
import org.switchyard.serial.graph.node.Node;
import org.switchyard.serial.graph.node.NodeBuilder;

public abstract class AccessNode
implements Node {
    static final Set<String> IGNORED_ACCESS_NAMES;

    Set<String> getIgnoredAccessNames() {
        return IGNORED_ACCESS_NAMES;
    }

    public abstract Integer getClazz();

    public abstract void setClazz(Integer var1);

    public abstract Map<String, Integer> getIds();

    public abstract void setIds(Map<String, Integer> var1);

    @Override
    public void compose(Object obj, Graph graph) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            this.setClazz(NodeBuilder.build(clazz, graph));
            for (Access access : this.getAccessList(clazz)) {
                Integer id;
                Object value;
                if (!(access instanceof FieldAccess) && !access.isWriteable() || (value = access.read(obj)) == null) continue;
                Map<String, Integer> ids = this.getIds();
                if (ids == null) {
                    ids = new LinkedHashMap<String, Integer>();
                    this.setIds(ids);
                }
                if ((id = NodeBuilder.build(value, graph)) == null) continue;
                ids.put(access.getName(), id);
            }
        }
    }

    @Override
    public Object decompose(final Graph graph) {
        Object obj;
        if (this.getClazz() == null) {
            return null;
        }
        Class clazz = (Class)graph.decomposeReference(this.getClazz());
        Factory factory = Factory.getFactory(clazz);
        if (factory.supports(clazz)) {
            obj = factory.create(clazz, this);
        } else {
            String className = clazz != null ? clazz.getName() : "null";
            SerialLogger.ROOT_LOGGER.classUnsupportedByFactoryReturningNull(className, factory.getClass().getName());
            obj = null;
        }
        Map<String, Integer> ids = this.getIds();
        if (obj != null && ids != null) {
            for (final Access access : this.getAccessList(clazz)) {
                final Integer id = ids.get(access.getName());
                if (id == null) continue;
                graph.addResolution(new Runnable(){

                    @Override
                    public void run() {
                        Object[] value = graph.decomposeReference(id);
                        if (value != null) {
                            boolean skip = !access.isWriteable();
                            Class accessType = access.getType();
                            if (access instanceof FieldAccess) {
                                if (NodeBuilder.isCollection(accessType) && value instanceof Collection) {
                                    ((Collection)access.read(obj)).addAll((Collection)value);
                                    skip = true;
                                } else if (NodeBuilder.isMap(accessType) && value instanceof Map) {
                                    ((Map)access.read(obj)).putAll((Map)value);
                                    skip = true;
                                }
                            }
                            if (!skip) {
                                if (NodeBuilder.isArray(accessType) && value.getClass().isArray()) {
                                    Object[] old_array = value;
                                    Object[] new_array = (Object[])Array.newInstance(accessType.getComponentType(), old_array.length);
                                    System.arraycopy(old_array, 0, new_array, 0, old_array.length);
                                    value = new_array;
                                }
                                access.write(obj, (Object)value);
                            }
                        }
                    }
                });
            }
        }
        return obj;
    }

    private List<Access> getAccessList(Class<?> clazz) {
        ArrayList<Access> accessList = new ArrayList<Access>();
        if (clazz.getAnnotation(Deprecated.class) != null) {
            return accessList;
        }
        Strategy strategy = clazz.getAnnotation(Strategy.class);
        AccessType accessType = strategy != null ? strategy.access() : AccessType.BEAN;
        CoverageType coverageType = strategy != null ? strategy.coverage() : CoverageType.INCLUSIVE;
        switch (accessType) {
            case BEAN: {
                BeanInfo info;
                try {
                    info = Introspector.getBeanInfo(clazz);
                }
                catch (IntrospectionException ie) {
                    throw new RuntimeException(ie);
                }
                for (PropertyDescriptor desc : info.getPropertyDescriptors()) {
                    String readName;
                    Method readMethod = desc.getReadMethod();
                    if ((!CoverageType.INCLUSIVE.equals((Object)coverageType) || readMethod.getAnnotation(Exclude.class) != null) && (!CoverageType.EXCLUSIVE.equals((Object)coverageType) || readMethod.getAnnotation(Include.class) == null) || readMethod.getAnnotation(Deprecated.class) != null) continue;
                    BeanAccess access = null;
                    Method writeMethod = desc.getWriteMethod();
                    if (writeMethod == null && ((readName = readMethod.getName()).startsWith("get") || readName.startsWith("is"))) {
                        Class<?> returnClass;
                        String writeName = "set" + (readName.startsWith("get") ? readName.substring(3) : readName.substring(2));
                        Class<?> declaringClass = readMethod.getDeclaringClass();
                        try {
                            writeMethod = declaringClass.getDeclaredMethod(writeName, desc.getPropertyType());
                        }
                        catch (NoSuchMethodException nsme1) {
                            try {
                                writeMethod = declaringClass.getMethod(writeName, desc.getPropertyType());
                            }
                            catch (NoSuchMethodException nsme2) {
                                writeMethod = null;
                            }
                        }
                        if (writeMethod != null && ((returnClass = writeMethod.getReturnType()) == null || returnClass.isAssignableFrom(declaringClass))) {
                            access = new MethodAccess(readMethod, writeMethod);
                        }
                    }
                    if (access == null) {
                        access = new BeanAccess(desc);
                    }
                    if (!access.isReadable() || this.getIgnoredAccessNames().contains(access.getName())) continue;
                    accessList.add((Access)access);
                }
                break;
            }
            case FIELD: {
                for (Field field : clazz.getDeclaredFields()) {
                    FieldAccess access;
                    if ((!CoverageType.INCLUSIVE.equals((Object)coverageType) || field.getAnnotation(Exclude.class) != null) && (!CoverageType.EXCLUSIVE.equals((Object)coverageType) || field.getAnnotation(Include.class) == null) || field.getAnnotation(Deprecated.class) != null || Modifier.isTransient(field.getModifiers()) || !(access = new FieldAccess(field)).isReadable()) continue;
                    accessList.add((Access)access);
                }
                break;
            }
        }
        return accessList;
    }

    static {
        HashSet<String> ignoredAccessNames = new HashSet<String>();
        ignoredAccessNames.add("class");
        ignoredAccessNames.add("ignoredAccessNames");
        IGNORED_ACCESS_NAMES = Collections.unmodifiableSet(ignoredAccessNames);
    }
}

