/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.graph;

import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.switchyard.serial.graph.node.Node;
import org.switchyard.serial.graph.node.NodeBuilder;

public final class Graph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer _root;
    private Map<Integer, Object> _references = new LinkedHashMap<Integer, Object>();
    private transient Map<Object, Integer> _ids;
    private transient AtomicInteger _sequence;
    private transient Queue<Runnable> _resolutions;

    public Graph() {
    }

    public Graph(Object obj) {
        this.composeRoot(obj);
    }

    public Integer getRoot() {
        return this._root;
    }

    public void setRoot(Integer root) {
        this._root = root;
    }

    public Map<Integer, Object> getReferences() {
        return this._references;
    }

    public void setReferences(Map<Integer, Object> references) {
        this._references = references;
    }

    public Object getReference(Integer id) {
        return this._references.get(id);
    }

    public Integer getReferenceId(Object obj) {
        if (obj != null) {
            for (Map.Entry<Integer, Object> entry : this._references.entrySet()) {
                if (entry.getValue() != obj) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void putReference(Integer id, Object obj) {
        this._references.put(id, obj);
    }

    private Queue<Runnable> getResolutions() {
        if (this._resolutions == null) {
            this._resolutions = new ConcurrentLinkedQueue<Runnable>();
        }
        return this._resolutions;
    }

    public void addResolution(Runnable res) {
        this.getResolutions().offer(res);
    }

    public void composeRoot(Object obj) {
        this.setRoot(NodeBuilder.build(obj, this));
    }

    public Object decomposeRoot() {
        Object obj = this.decomposeReference(this.getRoot());
        Runnable res = this.getResolutions().poll();
        while (res != null) {
            res.run();
            res = this.getResolutions().poll();
        }
        return obj;
    }

    public Object decomposeReference(Integer id) {
        Object obj = this.getReference(id);
        if (obj instanceof Node) {
            obj = ((Node)obj).decompose(this);
            this.putReference(id, obj);
        }
        return obj;
    }

    private Map<Object, Integer> getIds() {
        if (this._ids == null) {
            this._ids = new IdentityHashMap<Object, Integer>();
        }
        return this._ids;
    }

    private Integer nextId() {
        if (this._sequence == null) {
            this._sequence = new AtomicInteger(0);
        }
        return this._sequence.incrementAndGet();
    }

    public Integer id(Object obj) {
        if (obj == null) {
            return 0;
        }
        Map<Object, Integer> ids = this.getIds();
        Integer id = ids.get(obj);
        if (id == null) {
            id = this.nextId();
            ids.put(obj, id);
        }
        return id;
    }
}

