/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.switchyard.ServiceSecurity;
import org.switchyard.security.service.DefaultServiceSecurity;
import org.switchyard.security.service.ServiceDomainSecurity;
import org.switchyard.security.system.SystemSecurity;

public class DefaultServiceDomainSecurity
implements ServiceDomainSecurity {
    private static final String FORMAT = DefaultServiceDomainSecurity.class.getSimpleName() + "@%s[serviceSecurities=%s, systemSecurity=%s]";
    private final Map<String, ServiceSecurity> _serviceSecurities;
    private final SystemSecurity _systemSecurity;

    public DefaultServiceDomainSecurity() {
        this(null, null);
    }

    public DefaultServiceDomainSecurity(Map<String, ServiceSecurity> serviceSecurities, SystemSecurity systemSecurity) {
        HashMap<String, ServiceSecurity> tmpServiceSecurities = new HashMap<String, ServiceSecurity>();
        if (serviceSecurities != null) {
            tmpServiceSecurities.putAll(serviceSecurities);
        }
        if (!tmpServiceSecurities.containsKey("default")) {
            tmpServiceSecurities.put("default", new DefaultServiceSecurity());
        }
        this._serviceSecurities = Collections.unmodifiableMap(tmpServiceSecurities);
        this._systemSecurity = systemSecurity != null ? systemSecurity : SystemSecurity.DEFAULT;
    }

    @Override
    public ServiceSecurity getServiceSecurity(String name) {
        ServiceSecurity serviceSecurity;
        ServiceSecurity serviceSecurity2 = serviceSecurity = name != null ? this._serviceSecurities.get(name) : null;
        if (serviceSecurity == null) {
            serviceSecurity = this._serviceSecurities.get("default");
        }
        return serviceSecurity;
    }

    @Override
    public SystemSecurity getSystemSecurity() {
        return this._systemSecurity;
    }

    public String toString() {
        return String.format(FORMAT, System.identityHashCode(this), this._serviceSecurities, this._systemSecurity);
    }
}

