/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.spi;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.switchyard.ServiceSecurity;
import org.switchyard.security.SecurityContext;
import org.switchyard.security.spi.JaasSecurityProvider;

public abstract class SecurityProvider {
    private static final Logger LOGGER;
    private static final SecurityProvider INSTANCE;

    public abstract boolean authenticate(ServiceSecurity var1, SecurityContext var2);

    public abstract boolean propagate(ServiceSecurity var1, SecurityContext var2);

    public abstract boolean addRunAs(ServiceSecurity var1, SecurityContext var2);

    public abstract boolean checkRolesAllowed(ServiceSecurity var1, SecurityContext var2);

    public abstract boolean clear(ServiceSecurity var1, SecurityContext var2);

    public static final SecurityProvider instance() {
        return INSTANCE;
    }

    static {
        JaasSecurityProvider instance;
        LOGGER = Logger.getLogger(SecurityProvider.class);
        try {
            ServiceLoader<SecurityProvider> services = ServiceLoader.load(SecurityProvider.class, SecurityProvider.class.getClassLoader());
            Iterator<SecurityProvider> iterator = services.iterator();
            instance = iterator.hasNext() ? iterator.next() : null;
        }
        catch (Throwable t) {
            instance = null;
        }
        SecurityProvider securityProvider = INSTANCE = instance != null ? instance : new JaasSecurityProvider();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Using SecurityProvider implementation: " + INSTANCE.getClass().getName()));
        }
    }
}

