/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.credential.extractor;

import java.io.ByteArrayInputStream;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.switchyard.common.codec.Base64;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.security.credential.AssertionCredential;
import org.switchyard.security.credential.CertificateCredential;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.NameCredential;
import org.switchyard.security.credential.PasswordCredential;
import org.switchyard.security.credential.extractor.CredentialExtractor;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPMessageCredentialExtractor
implements CredentialExtractor<SOAPMessage> {
    private static final String WSSE_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String WSSE_NS2 = "http://schemas.xmlsoap.org/ws/2002/04/secext";
    private static final String WSSE11_NS = "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
    private static final String WSSE_LN = "Security";
    private static final QName WSSE_QNAME = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    private static final QName WSSE_2_QNAME = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "Security");
    private static final QName WSSE_11_QNAME = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Security");
    private static final String X509V3 = "X509v3";
    private static final String X509PKIPATHV1 = "X509PKIPathv1";
    private static final String PKCS7 = "PKCS7";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<Credential> extract(SOAPMessage source) {
        HashSet<Credential> credentials = new HashSet<Credential>();
        if (source == null) return credentials;
        try {
            SOAPHeaderElement securityHeader = this.getSecurityHeader(source.getSOAPPart().getEnvelope());
            if (securityHeader == null) return credentials;
            Iterator iter = securityHeader.getChildElements();
            while (iter.hasNext()) {
                Node securityTokenNode = (Node)iter.next();
                if (securityTokenNode.getNodeType() != 1) continue;
                String securityTokenNodeName = XMLHelper.nameOf((Node)securityTokenNode);
                if ("Assertion".equalsIgnoreCase(securityTokenNodeName)) {
                    credentials.add(new AssertionCredential((Element)securityTokenNode));
                    continue;
                }
                if ("UsernameToken".equalsIgnoreCase(securityTokenNodeName)) {
                    NodeList usernameChildElements = securityTokenNode.getChildNodes();
                    for (int i = 0; i < usernameChildElements.getLength(); ++i) {
                        String password;
                        Node usernameChildNode = usernameChildElements.item(i);
                        String usernameChildeNodeName = XMLHelper.nameOf((Node)usernameChildNode);
                        if ("Username".equalsIgnoreCase(usernameChildeNodeName)) {
                            String name = XMLHelper.valueOf((Node)usernameChildNode.getFirstChild());
                            if (name == null) continue;
                            credentials.add(new NameCredential(name));
                            continue;
                        }
                        if (!"Password".equalsIgnoreCase(usernameChildeNodeName) || (password = XMLHelper.valueOf((Node)usernameChildNode.getFirstChild())) == null) continue;
                        credentials.add(new PasswordCredential(password));
                    }
                    continue;
                }
                if (!"BinarySecurityToken".equalsIgnoreCase(securityTokenNodeName)) continue;
                NamedNodeMap attributes = securityTokenNode.getAttributes();
                String encodingType = this.stripNS(XMLHelper.valueOf((Node)attributes.getNamedItem("EncodingType")));
                String valueType = this.stripNS(XMLHelper.valueOf((Node)attributes.getNamedItem("ValueType")));
                String certString = XMLHelper.valueOf((Node)securityTokenNode.getFirstChild());
                byte[] certBytes = null;
                certBytes = "Base64Binary".equalsIgnoreCase(encodingType) ? Base64.decode((String)certString) : certString.getBytes();
                try {
                    CertificateFactory factory = CertificateFactory.getInstance(this.certificateMatch(valueType));
                    ByteArrayInputStream certStream = new ByteArrayInputStream(certBytes);
                    if (X509PKIPATHV1.equals(valueType)) {
                        CertPath path = factory.generateCertPath(certStream);
                        for (Certificate certificate : path.getCertificates()) {
                            credentials.add(new CertificateCredential(certificate));
                        }
                        continue;
                    }
                    if (X509V3.equals(valueType)) {
                        Certificate certificate = factory.generateCertificate(certStream);
                        credentials.add(new CertificateCredential(certificate));
                        continue;
                    }
                    if (!PKCS7.equals(valueType)) throw new IllegalArgumentException(valueType + " not implemented");
                    throw new IllegalArgumentException(valueType + " not implemented (although recognized)");
                }
                catch (CertificateException ce) {
                    throw new RuntimeException("Could not create certificate(s): " + ce.getMessage(), ce);
                    return credentials;
                }
            }
        }
        catch (SOAPException se) {
            throw new RuntimeException(se);
        }
    }

    private SOAPHeaderElement getSecurityHeader(SOAPEnvelope envelope) throws SOAPException {
        SOAPHeader header;
        if (envelope != null && (header = envelope.getHeader()) != null) {
            Iterator iter = header.getChildElements(WSSE_QNAME);
            if (iter.hasNext()) {
                return (SOAPHeaderElement)iter.next();
            }
            iter = header.getChildElements(WSSE_2_QNAME);
            if (iter.hasNext()) {
                return (SOAPHeaderElement)iter.next();
            }
            iter = header.getChildElements(WSSE_11_QNAME);
            if (iter.hasNext()) {
                return (SOAPHeaderElement)iter.next();
            }
        }
        return null;
    }

    private String stripNS(String value) {
        if (value != null) {
            if (value.startsWith("http")) {
                int idx = value.indexOf(35);
                if (idx > 0) {
                    value = value.substring(idx + 1);
                }
            } else {
                int idx = value.indexOf(58);
                if (idx > 0) {
                    value = value.substring(idx + 1);
                }
            }
        }
        return value;
    }

    private String certificateMatch(String valueType) {
        if (valueType.startsWith("X509")) {
            return "X.509";
        }
        return valueType;
    }
}

