/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.switchyard.Exchange;
import org.switchyard.security.SecurityExchange;
import org.switchyard.security.credential.Credential;

public final class SecurityContext {
    private static final String FORMAT = SecurityContext.class.getSimpleName() + "[credentials=%s, securityDomainsToSubjects=%s]";
    private final Set<Credential> _credentials = Collections.synchronizedSet(new HashSet());
    private final Map<String, Subject> _securityDomainsToSubjects = Collections.synchronizedMap(new HashMap());

    public Set<Credential> getCredentials() {
        return this._credentials;
    }

    public <T extends Credential> Set<T> getCredentials(Class<T> clazz) {
        HashSet<T> matches = new HashSet<T>();
        for (Credential credential : this.getCredentials()) {
            if (credential == null || !clazz.isAssignableFrom(credential.getClass())) continue;
            matches.add(clazz.cast(credential));
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearCredentials() {
        Set<Credential> set = this._credentials;
        synchronized (set) {
            this._credentials.clear();
        }
    }

    public synchronized Subject getSubject(String securityDomain) {
        Subject subject = this._securityDomainsToSubjects.get(securityDomain);
        if (subject == null) {
            subject = new Subject();
            this._securityDomainsToSubjects.put(securityDomain, subject);
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearSubject(String securityDomain) {
        Map<String, Subject> map = this._securityDomainsToSubjects;
        synchronized (map) {
            this._securityDomainsToSubjects.remove(securityDomain);
        }
    }

    public boolean isCallerInRole(String roleName, String securityDomain) {
        for (Principal principal : this.getSubject(securityDomain).getPrincipals()) {
            Group group;
            if (!(principal instanceof Group) || !(group = (Group)principal).getName().equalsIgnoreCase("Roles")) continue;
            Enumeration roles = group.members();
            while (roles.hasMoreElements()) {
                Principal role = (Principal)roles.nextElement();
                if (!role.getName().equals(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.format(FORMAT, this._credentials, this._securityDomainsToSubjects);
    }

    public static SecurityContext get(Exchange exchange) {
        if (exchange instanceof SecurityExchange) {
            return ((SecurityExchange)exchange).getSecurityContext();
        }
        throw new IllegalArgumentException("Exchange [" + exchange + "] is not an instance of " + SecurityExchange.class.getName());
    }
}

