/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.switchyard.ServiceSecurity;

public class DefaultServiceSecurity
implements ServiceSecurity {
    private static final String FORMAT = DefaultServiceSecurity.class.getSimpleName() + "[name=%s, callbackHandler=%s, properties=%s, rolesAllowed=%s, runAs=%s, securityDomain=%s]";
    private String _name;
    private Class<?> _callbackHandler;
    private Map<String, String> _properties = new LinkedHashMap<String, String>();
    private Set<String> _rolesAllowed = new LinkedHashSet<String>();
    private String _runAs;
    private String _securityDomain;

    public String getName() {
        if (this._name != null) {
            return this._name;
        }
        return "default";
    }

    public DefaultServiceSecurity setName(String name) {
        this._name = name;
        return this;
    }

    public Class<?> getCallbackHandler() {
        return this._callbackHandler;
    }

    public DefaultServiceSecurity setCallbackHandler(Class<?> callbackHandler) {
        this._callbackHandler = callbackHandler;
        return this;
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public DefaultServiceSecurity setProperties(Map<String, String> properties) {
        this._properties.clear();
        if (properties != null) {
            this._properties.putAll(properties);
        }
        return this;
    }

    public Set<String> getRolesAllowed() {
        return this._rolesAllowed;
    }

    public DefaultServiceSecurity setRolesAllowed(Set<String> rolesAllowed) {
        this._rolesAllowed.clear();
        if (rolesAllowed != null) {
            this._rolesAllowed.addAll(rolesAllowed);
        }
        return this;
    }

    public String getRunAs() {
        return this._runAs;
    }

    public DefaultServiceSecurity setRunAs(String runAs) {
        this._runAs = runAs;
        return this;
    }

    public String getSecurityDomain() {
        if (this._securityDomain != null) {
            return this._securityDomain;
        }
        return "other";
    }

    public DefaultServiceSecurity setSecurityDomain(String securityDomain) {
        this._securityDomain = securityDomain;
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.getName(), this._callbackHandler, this._properties, this._rolesAllowed, this._runAs, this.getSecurityDomain());
    }
}

