/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io.graph;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.switchyard.common.type.Classes;
import org.switchyard.common.type.reflect.Access;
import org.switchyard.common.type.reflect.BeanAccess;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.internal.io.graph.Graph;
import org.switchyard.internal.io.graph.GraphBuilder;
import org.switchyard.io.Serialization;

public class PropertyGraph<T>
implements Graph<T> {
    private String _type;
    private LinkedHashMap<String, Graph<?>> _properties;

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public LinkedHashMap<String, Graph<?>> getProperties() {
        return this._properties;
    }

    public void setProperties(LinkedHashMap<String, Graph<?>> properties) {
        this._properties = properties;
    }

    @Override
    public void compose(T object, Map<Integer, Object> visited) throws IOException {
        Integer id;
        if (object != null && !visited.containsKey(id = Integer.valueOf(System.identityHashCode(object)))) {
            visited.put(id, this);
            Class<?> clazz = object.getClass();
            this.setType(clazz.getName());
            LinkedHashMap<String, Graph<Object>> props = null;
            for (Access<?> access : this.getAccessList(clazz)) {
                Object value;
                if (!(access instanceof FieldAccess) && !access.isWriteable() || (value = access.read(object)) == null) continue;
                if (props == null) {
                    props = new LinkedHashMap<String, Graph<Object>>();
                }
                props.put(access.getName(), GraphBuilder.build(value, visited));
            }
            if (props != null) {
                this.setProperties(props);
            }
        }
    }

    @Override
    public T decompose(Map<Integer, Object> visited) throws IOException {
        Class clazz;
        if (visited == null) {
            visited = new LinkedHashMap<Integer, Object>();
        }
        Integer id = System.identityHashCode(this);
        Object object = visited.get(id);
        String type = this.getType();
        if (object == null && type != null && (object = this.getFactory(clazz = Classes.forName((String)type, this.getClass())).create(clazz)) != null) {
            visited.put(id, object);
            for (Access<?> access : this.getAccessList(clazz)) {
                Object value;
                Graph graph;
                LinkedHashMap<String, Graph<?>> props = this.getProperties();
                if (props == null || (graph = (Graph)props.get(access.getName())) == null || (value = graph.decompose(visited)) == null) continue;
                boolean skip = !access.isWriteable();
                Class accessType = access.getType();
                Class<?> valueType = value.getClass();
                if (access instanceof FieldAccess) {
                    if (GraphBuilder.isCollection(accessType) && value instanceof Collection) {
                        ((Collection)access.read(object)).addAll((Collection)value);
                        skip = true;
                    } else if (GraphBuilder.isMap(accessType) && value instanceof Map) {
                        ((Map)access.read(object)).putAll((Map)value);
                        skip = true;
                    }
                }
                if (skip) continue;
                if (GraphBuilder.isArray(accessType) && valueType.isArray()) {
                    Object[] old_array = (Object[])value;
                    Object[] new_array = (Object[])Array.newInstance(accessType.getComponentType(), old_array.length);
                    System.arraycopy(old_array, 0, new_array, 0, old_array.length);
                    value = new_array;
                }
                access.write(object, value);
            }
        }
        return (T)object;
    }

    private List<Access<?>> getAccessList(Class<?> clazz) {
        ArrayList accessList = new ArrayList();
        if (clazz.getAnnotation(Deprecated.class) != null) {
            return accessList;
        }
        Serialization.Strategy strategy = clazz.getAnnotation(Serialization.Strategy.class);
        Serialization.AccessType accessType = strategy != null ? strategy.access() : Serialization.AccessType.BEAN;
        Serialization.CoverageType coverageType = strategy != null ? strategy.coverage() : Serialization.CoverageType.INCLUSIVE;
        switch (accessType) {
            case BEAN: {
                BeanInfo info;
                try {
                    info = Introspector.getBeanInfo(clazz);
                }
                catch (IntrospectionException ie) {
                    throw new SwitchYardException((Throwable)ie);
                }
                for (PropertyDescriptor desc : info.getPropertyDescriptors()) {
                    BeanAccess access;
                    Method method = desc.getReadMethod();
                    if ((!Serialization.CoverageType.INCLUSIVE.equals((Object)coverageType) || method.getAnnotation(Serialization.Exclude.class) != null) && (!Serialization.CoverageType.EXCLUSIVE.equals((Object)coverageType) || method.getAnnotation(Serialization.Include.class) == null) || method.getAnnotation(Deprecated.class) != null || !(access = new BeanAccess(desc)).isReadable() || "class".equals(access.getName())) continue;
                    accessList.add((Access<?>)access);
                }
                break;
            }
            case FIELD: {
                for (Field field : clazz.getDeclaredFields()) {
                    FieldAccess access;
                    if ((!Serialization.CoverageType.INCLUSIVE.equals((Object)coverageType) || field.getAnnotation(Serialization.Exclude.class) != null) && (!Serialization.CoverageType.EXCLUSIVE.equals((Object)coverageType) || field.getAnnotation(Serialization.Include.class) == null) || field.getAnnotation(Deprecated.class) != null || Modifier.isTransient(field.getModifiers()) || !(access = new FieldAccess(field)).isReadable()) continue;
                    accessList.add((Access<?>)access);
                }
                break;
            }
        }
        return accessList;
    }

    private Serialization.Factory<T> getFactory(Class<T> clazz) throws IOException {
        Serialization.Strategy strategy = clazz.getAnnotation(Serialization.Strategy.class);
        if (strategy != null) {
            try {
                return (Serialization.Factory)strategy.factory().newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new IOException(iae);
            }
            catch (InstantiationException ie) {
                throw new IOException(ie);
            }
        }
        return new Serialization.DefaultFactory();
    }

    public String toString() {
        String type = this.getType();
        if (type != null) {
            int pos = type.lastIndexOf(36);
            if (pos == -1) {
                pos = type.lastIndexOf(46);
            }
            if (pos != -1) {
                type = type.substring(pos + 1, type.length());
            }
        }
        StringBuilder props = new StringBuilder();
        LinkedHashMap<String, Graph<?>> properties = this.getProperties();
        if (properties != null) {
            props.append('[');
            boolean started = false;
            for (Map.Entry<String, Graph<?>> entry : properties.entrySet()) {
                if (!started) {
                    started = true;
                } else {
                    props.append(',');
                }
                props.append(entry.getKey());
            }
            props.append(']');
        } else {
            props.append("null");
        }
        return "PropertyGraph(type=" + type + ", properties=" + props + ")";
    }
}

