/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.switchyard.common.io.CountingOutputStream;
import org.switchyard.internal.io.BaseSerializer;
import org.switchyard.internal.io.Serializer;

public final class ZIPSerializer
extends BaseSerializer {
    private final Serializer _serializer;

    public ZIPSerializer(Serializer serializer) {
        this._serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int serialize(T obj, Class<T> type, OutputStream out, int bufferSize) throws IOException {
        out = new CountingOutputStream(out);
        ZipOutputStream zip = new ZipOutputStream(out);
        try {
            zip.putNextEntry(new ZipEntry("z"));
            this._serializer.serialize(obj, type, zip, bufferSize);
            zip.closeEntry();
            zip.finish();
            zip.flush();
        }
        finally {
            if (this.isCloseEnabled()) {
                zip.close();
            }
        }
        return ((CountingOutputStream)out).getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(InputStream in, Class<T> type, int bufferSize) throws IOException {
        ZipInputStream zip = new ZipInputStream(in);
        try {
            zip.getNextEntry();
            T t = this._serializer.deserialize(zip, type, bufferSize);
            return t;
        }
        finally {
            if (this.isCloseEnabled()) {
                zip.close();
            }
        }
    }
}

