/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io;

import org.switchyard.internal.io.BeanXMLSerializer;
import org.switchyard.internal.io.GZIPSerializer;
import org.switchyard.internal.io.GraphProtostuffSerializer;
import org.switchyard.internal.io.GraphSerializer;
import org.switchyard.internal.io.JSONProtostuffSerializer;
import org.switchyard.internal.io.NativeProtostuffSerializer;
import org.switchyard.internal.io.NumericJSONProtostuffSerializer;
import org.switchyard.internal.io.ObjectStreamSerializer;
import org.switchyard.internal.io.ProtobufProtostuffSerializer;
import org.switchyard.internal.io.Serializer;
import org.switchyard.internal.io.XMLProtostuffSerializer;
import org.switchyard.internal.io.ZIPSerializer;

public enum SerializerType {
    OBJECT_STREAM(new ObjectStreamSerializer()),
    ZIP_OBJECT_STREAM(new ZIPSerializer(OBJECT_STREAM.instance())),
    GZIP_OBJECT_STREAM(new GZIPSerializer(OBJECT_STREAM.instance())),
    GRAPH_OBJECT_STREAM(new GraphSerializer(OBJECT_STREAM.instance())),
    ZIP_GRAPH_OBJECT_STREAM(new ZIPSerializer(GRAPH_OBJECT_STREAM.instance())),
    GZIP_GRAPH_OBJECT_STREAM(new GZIPSerializer(GRAPH_OBJECT_STREAM.instance())),
    BEAN_XML(new BeanXMLSerializer()),
    ZIP_BEAN_XML(new ZIPSerializer(BEAN_XML.instance())),
    GZIP_BEAN_XML(new GZIPSerializer(BEAN_XML.instance())),
    GRAPH_BEAN_XML(new GraphSerializer(BEAN_XML.instance())),
    ZIP_GRAPH_BEAN_XML(new ZIPSerializer(GRAPH_BEAN_XML.instance())),
    GZIP_GRAPH_BEAN_XML(new GZIPSerializer(GRAPH_BEAN_XML.instance())),
    GRAPH_PROTOSTUFF(new GraphProtostuffSerializer()),
    ZIP_GRAPH_PROTOSTUFF(new ZIPSerializer(GRAPH_PROTOSTUFF.instance())),
    GZIP_GRAPH_PROTOSTUFF(new GZIPSerializer(GRAPH_PROTOSTUFF.instance())),
    GRAPH_GRAPH_PROTOSTUFF(new GraphSerializer(GRAPH_PROTOSTUFF.instance())),
    ZIP_GRAPH_GRAPH_PROTOSTUFF(new ZIPSerializer(GRAPH_GRAPH_PROTOSTUFF.instance())),
    GZIP_GRAPH_GRAPH_PROTOSTUFF(new GZIPSerializer(GRAPH_GRAPH_PROTOSTUFF.instance())),
    NATIVE_PROTOSTUFF(new NativeProtostuffSerializer()),
    ZIP_NATIVE_PROTOSTUFF(new ZIPSerializer(NATIVE_PROTOSTUFF.instance())),
    GZIP_NATIVE_PROTOSTUFF(new GZIPSerializer(NATIVE_PROTOSTUFF.instance())),
    GRAPH_NATIVE_PROTOSTUFF(new GraphSerializer(NATIVE_PROTOSTUFF.instance())),
    ZIP_GRAPH_NATIVE_PROTOSTUFF(new ZIPSerializer(GRAPH_NATIVE_PROTOSTUFF.instance())),
    GZIP_GRAPH_NATIVE_PROTOSTUFF(new GZIPSerializer(GRAPH_NATIVE_PROTOSTUFF.instance())),
    PROTOBUF_PROTOSTUFF(new ProtobufProtostuffSerializer()),
    ZIP_PROTOBUF_PROTOSTUFF(new ZIPSerializer(PROTOBUF_PROTOSTUFF.instance())),
    GZIP_PROTOBUF_PROTOSTUFF(new GZIPSerializer(PROTOBUF_PROTOSTUFF.instance())),
    GRAPH_PROTOBUF_PROTOSTUFF(new GraphSerializer(PROTOBUF_PROTOSTUFF.instance())),
    ZIP_GRAPH_PROTOBUF_PROTOSTUFF(new ZIPSerializer(GRAPH_PROTOBUF_PROTOSTUFF.instance())),
    GZIP_GRAPH_PROTOBUF_PROTOSTUFF(new GZIPSerializer(GRAPH_PROTOBUF_PROTOSTUFF.instance())),
    JSON_PROTOSTUFF(new JSONProtostuffSerializer()),
    ZIP_JSON_PROTOSTUFF(new ZIPSerializer(JSON_PROTOSTUFF.instance())),
    GZIP_JSON_PROTOSTUFF(new GZIPSerializer(JSON_PROTOSTUFF.instance())),
    GRAPH_JSON_PROTOSTUFF(new GraphSerializer(JSON_PROTOSTUFF.instance())),
    ZIP_GRAPH_JSON_PROTOSTUFF(new ZIPSerializer(GRAPH_JSON_PROTOSTUFF.instance())),
    GZIP_GRAPH_JSON_PROTOSTUFF(new GZIPSerializer(GRAPH_JSON_PROTOSTUFF.instance())),
    NUMERIC_JSON_PROTOSTUFF(new NumericJSONProtostuffSerializer()),
    ZIP_NUMERIC_JSON_PROTOSTUFF(new ZIPSerializer(NUMERIC_JSON_PROTOSTUFF.instance())),
    GZIP_NUMERIC_JSON_PROTOSTUFF(new GZIPSerializer(NUMERIC_JSON_PROTOSTUFF.instance())),
    GRAPH_NUMERIC_JSON_PROTOSTUFF(new GraphSerializer(NUMERIC_JSON_PROTOSTUFF.instance())),
    ZIP_GRAPH_NUMERIC_JSON_PROTOSTUFF(new ZIPSerializer(GRAPH_NUMERIC_JSON_PROTOSTUFF.instance())),
    GZIP_GRAPH_NUMERIC_JSON_PROTOSTUFF(new GZIPSerializer(GRAPH_NUMERIC_JSON_PROTOSTUFF.instance())),
    XML_PROTOSTUFF(new XMLProtostuffSerializer()),
    ZIP_XML_PROTOSTUFF(new ZIPSerializer(XML_PROTOSTUFF.instance())),
    GZIP_XML_PROTOSTUFF(new GZIPSerializer(XML_PROTOSTUFF.instance())),
    GRAPH_XML_PROTOSTUFF(new GraphSerializer(XML_PROTOSTUFF.instance())),
    ZIP_GRAPH_XML_PROTOSTUFF(new ZIPSerializer(GRAPH_XML_PROTOSTUFF.instance())),
    GZIP_GRAPH_XML_PROTOSTUFF(new GZIPSerializer(GRAPH_XML_PROTOSTUFF.instance())),
    DEFAULT(GZIP_GRAPH_GRAPH_PROTOSTUFF.instance());

    private final Serializer _instance;

    private SerializerType(Serializer instance) {
        this._instance = instance;
    }

    public final Serializer instance() {
        return this._instance;
    }

    public static final Serializer instanceOf(String name) {
        SerializerType type;
        if (name != null && (type = SerializerType.valueOf(name = name.trim().toUpperCase())) != null) {
            return type.instance();
        }
        return null;
    }
}

