/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.HashMap;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.switchyard.Message;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.io.Serialization;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

@Serialization.Strategy(access=Serialization.AccessType.FIELD, coverage=Serialization.CoverageType.INCLUSIVE)
public class DefaultMessage
implements Message {
    @Serialization.Exclude
    private TransformerRegistry _transformerRegistry;
    private Object _content;
    private Map<String, DataSource> _attachments = new HashMap<String, DataSource>();

    public DefaultMessage setTransformerRegistry(TransformerRegistry transformerRegistry) {
        this._transformerRegistry = transformerRegistry;
        return this;
    }

    public DefaultMessage addAttachment(String name, DataSource attachment) {
        this._attachments.put(name, attachment);
        return this;
    }

    public DataSource getAttachment(String name) {
        return this._attachments.get(name);
    }

    public DataSource removeAttachment(String name) {
        return this._attachments.remove(name);
    }

    public Map<String, DataSource> getAttachmentMap() {
        return new HashMap<String, DataSource>(this._attachments);
    }

    public Object getContent() {
        return this._content;
    }

    public <T> T getContent(Class<T> type) {
        QName toType;
        if (type == null) {
            throw new IllegalArgumentException("null 'type' argument.");
        }
        if (this._content == null) {
            return null;
        }
        if (type.isInstance(this._content)) {
            return type.cast(this._content);
        }
        if (this._transformerRegistry == null) {
            throw new SwitchYardException("Cannot convert from '" + this._content.getClass().getName() + "' to '" + type.getName() + "'.  No TransformRegistry available.");
        }
        QName fromType = JavaService.toMessageType(this._content.getClass());
        Transformer transformer = this._transformerRegistry.getTransformer(fromType, toType = JavaService.toMessageType(type));
        if (transformer == null) {
            throw new SwitchYardException("Cannot convert from '" + this._content.getClass().getName() + "' to '" + type.getName() + "'.  No registered Transformer available for transforming from '" + fromType + "' to '" + toType + "'.  A Transformer must be registered.");
        }
        Object transformedContent = transformer.transform(this._content);
        if (transformedContent == null) {
            throw new SwitchYardException("Error converting from '" + this._content.getClass().getName() + "' to '" + type.getName() + "'.  Transformer '" + transformer.getClass().getName() + "' returned null.");
        }
        if (!type.isInstance(transformedContent)) {
            throw new SwitchYardException("Error converting from '" + this._content.getClass().getName() + "' to '" + type.getName() + "'.  Transformer '" + transformer.getClass().getName() + "' returned incompatible type '" + transformedContent.getClass().getName() + "'.");
        }
        return type.cast(transformedContent);
    }

    public DefaultMessage setContent(Object content) {
        this._content = content;
        return this;
    }
}

