/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerChain;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.transform.TransformSequence;

public class DefaultHandlerChain
implements HandlerChain {
    private static Logger _logger = Logger.getLogger(DefaultHandlerChain.class);
    private final LinkedList<HandlerRef> _chain = new LinkedList();

    public DefaultHandlerChain() {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"Created empty DefaultHandlerChain.");
        }
    }

    private DefaultHandlerChain(List<HandlerRef> handlers) {
        this._chain.addAll(handlers);
    }

    public synchronized void addFirst(String handlerName, ExchangeHandler handler) {
        HandlerRef handlerRef = new HandlerRef(handlerName, handler);
        this._chain.addFirst(handlerRef);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Added ExchangeHandler instance at start of Handler Chain: " + handlerRef));
        }
    }

    public synchronized void addLast(String handlerName, ExchangeHandler handler) {
        HandlerRef handlerRef = new HandlerRef(handlerName, handler);
        this._chain.addLast(handlerRef);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Added ExchangeHandler instance at end of Handler Chain: " + handlerRef));
        }
    }

    public synchronized boolean replace(String handlerName, ExchangeHandler handler) {
        for (int i = 0; i < this._chain.size(); ++i) {
            if (!this._chain.get(i).getName().equals(handlerName)) continue;
            this._chain.remove(i);
            this._chain.add(i, new HandlerRef(handlerName, handler));
            return true;
        }
        return false;
    }

    public synchronized ExchangeHandler remove(String handlerName) {
        ExchangeHandler handler = null;
        for (HandlerRef ref : this._chain) {
            if (!ref.getName().equals(handlerName)) continue;
            handler = ref.getHandler();
            this._chain.remove(ref);
            break;
        }
        return handler;
    }

    public void handle(Exchange exchange) {
        if (exchange.getState() == ExchangeState.FAULT) {
            this.handleFault(exchange);
        } else {
            this.handleMessage(exchange);
        }
    }

    public void handleFault(Exchange exchange) {
        for (HandlerRef ref : this.listHandlers()) {
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Executing Fault ExchangeHandler (" + ref + ") on message Exchange instance (" + System.identityHashCode(exchange) + ")."));
                }
                ref.getHandler().handleFault(exchange);
            }
            catch (Exception e) {
                _logger.warn((Object)("Handler '" + ref.getName() + "' failed to handle fault."), (Throwable)e);
            }
        }
    }

    public void handleMessage(Exchange exchange) {
        try {
            for (HandlerRef ref : this.listHandlers()) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Executing ExchangeHandler (" + ref + ") on message Exchange instance (" + System.identityHashCode(exchange) + ")."));
                }
                ref.getHandler().handleMessage(exchange);
                if (exchange.getState() != ExchangeState.FAULT) continue;
                break;
            }
        }
        catch (HandlerException handlerEx) {
            _logger.error((Object)handlerEx);
            Message faultMessage = exchange.createMessage().setContent((Object)handlerEx);
            this.initFaultTransformsequence(exchange, handlerEx, faultMessage);
            exchange.sendFault(faultMessage);
        }
    }

    public List<ExchangeHandler> getHandlers() {
        LinkedList<ExchangeHandler> handlers = new LinkedList<ExchangeHandler>();
        for (HandlerRef hr : this.listHandlers()) {
            handlers.add(hr.getHandler());
        }
        return Collections.unmodifiableList(handlers);
    }

    private void initFaultTransformsequence(Exchange exchange, HandlerException handlerEx, Message faultMessage) {
        ExchangeContract contract = exchange.getContract();
        QName exceptionTypeName = contract.getServiceOperation().getFaultType();
        QName invokerFaultTypeName = contract.getInvokerInvocationMetaData().getFaultType();
        if (exceptionTypeName == null) {
            exceptionTypeName = JavaService.toMessageType(((Object)((Object)handlerEx)).getClass());
        }
        if (exceptionTypeName != null && invokerFaultTypeName != null) {
            TransformSequence.from((QName)exceptionTypeName).to(invokerFaultTypeName).associateWith(exchange, Scope.OUT);
        }
    }

    public DefaultHandlerChain copy() {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Cloning DefaultHandlerChain from a its list of Handlers: " + this.listHandlers()));
        }
        return new DefaultHandlerChain(this.listHandlers());
    }

    public String toString() {
        return this._chain.toString();
    }

    private synchronized List<HandlerRef> listHandlers() {
        return new LinkedList<HandlerRef>(this._chain);
    }

    private static final class HandlerRef {
        private final ExchangeHandler _handler;
        private final String _name;

        HandlerRef(String name, ExchangeHandler handler) {
            this._handler = handler;
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public ExchangeHandler getHandler() {
            return this._handler;
        }

        public String toString() {
            return "Name '" + this._name + "',  Class '" + this._handler.getClass().getName() + "'";
        }
    }
}

