/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deployment;

import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.switchyard.ServiceDomain;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.internal.Deployment;

public class SwitchYardDeployment {
    private final VFSDeploymentUnit _deployUnit;
    private ServiceDomainManager _domainManager;
    private Deployment _deployment;

    public SwitchYardDeployment(String deploymentName, VFSDeploymentUnit deploymentUnit, SwitchYardModel config, ServiceDomainManager domainManager) {
        this._deployUnit = deploymentUnit;
        this._domainManager = domainManager;
        this._deployment = new Deployment(config);
    }

    public void create() {
    }

    public void destroy() {
        this._domainManager.removeApplicationServiceDomain(this._deployment.getDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._deployUnit.getClassLoader());
            this._deployment.init(SwitchYardDeployment.createDomain(this._deployment.getConfig(), this._domainManager));
            this._deployment.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._deployUnit.getClassLoader());
            this._deployment.stop();
            this._deployment.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    private static ServiceDomain createDomain(SwitchYardModel config, ServiceDomainManager domainManager) {
        return domainManager.addApplicationServiceDomain(ServiceDomainManager.ROOT_DOMAIN, config);
    }
}

