/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deployment;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.log4j.Logger;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitVisitor;
import org.jboss.weld.integration.util.IdFactory;

public class CDIBeanManagerJNDIDeployer
extends AbstractRealDeployer {
    private static Logger _logger = Logger.getLogger(CDIBeanManagerJNDIDeployer.class);

    public CDIBeanManagerJNDIDeployer() {
        this.setStage(DeploymentStages.PRE_REAL);
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        if (this.isSwitchYardDeployment(unit)) {
            unit.visit((DeploymentUnitVisitor)new BinderVisitor());
        }
    }

    protected void internalUndeploy(DeploymentUnit unit) {
        if (this.isSwitchYardDeployment(unit)) {
            try {
                unit.visit((DeploymentUnitVisitor)new UnbinderVisitor());
            }
            catch (DeploymentException e) {
                _logger.debug((Object)("Deployment error undeploying " + unit.getSimpleName()));
            }
        }
    }

    private boolean isSwitchYardDeployment(DeploymentUnit unit) {
        return unit.getClassLoader().getResource("/META-INF/switchyard.xml") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getJavaComp(DeploymentUnit unit) throws DeploymentException {
        Context javaComp = null;
        InitialContext initialContext = null;
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(unit.getClassLoader());
            initialContext = new InitialContext();
            javaComp = (Context)initialContext.lookup("java:comp");
        }
        catch (Exception e) {
            throw new DeploymentException("Unexpected retrieving java:comp from JNDI namespace.", (Throwable)e);
        }
        finally {
            block15: {
                try {
                    if (initialContext == null) break block15;
                    try {
                        initialContext.close();
                    }
                    catch (NamingException e) {
                        throw new DeploymentException("Unexpected error closing InitialContext.", (Throwable)e);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalTCCL);
                }
            }
        }
        return javaComp;
    }

    private class UnbinderVisitor
    implements DeploymentUnitVisitor {
        private UnbinderVisitor() {
        }

        public void visit(DeploymentUnit unit) throws DeploymentException {
            if (unit.isTopLevel()) {
                try {
                    Context javaComp = CDIBeanManagerJNDIDeployer.this.getJavaComp(unit);
                    javaComp.unbind("BeanManager");
                    _logger.debug((Object)("CDI BeanManager successfully unbound from JNDI (java:comp) for SwitchYard deployment '" + unit.getName() + "'."));
                }
                catch (NamingException e) {
                    throw new DeploymentException("Error unbinding BeanManager.", (Throwable)e);
                }
            }
        }

        public void error(DeploymentUnit unit) {
            _logger.debug((Object)("Deployment error undeploying " + unit.getSimpleName()));
        }
    }

    private class BinderVisitor
    implements DeploymentUnitVisitor {
        private BinderVisitor() {
        }

        public void visit(DeploymentUnit unit) throws DeploymentException {
            if (unit.isTopLevel()) {
                Context javaComp = CDIBeanManagerJNDIDeployer.this.getJavaComp(unit);
                try {
                    Reference reference = new Reference("javax.enterprise.inject.spi.BeanManager", "org.jboss.weld.integration.deployer.jndi.JBossBeanManagerObjectFactory", null);
                    reference.add(new StringRefAddr("id", IdFactory.getIdFromClassLoader((ClassLoader)unit.getClassLoader())));
                    javaComp.bind("BeanManager", (Object)reference);
                    _logger.debug((Object)("CDI BeanManager successfully bound into JNDI (java:comp) for SwitchYard deployment '" + unit.getName() + "'."));
                }
                catch (NamingException e) {
                    throw new DeploymentException("Error binding BeanManager.", (Throwable)e);
                }
            }
        }

        public void error(DeploymentUnit unit) {
            _logger.debug((Object)("Deployment error deploying " + unit.getSimpleName()));
        }
    }
}

