/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.composite.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.switchyard.common.lang.Strings;
import org.switchyard.config.ConfigLogger;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseNamedModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.SCANamespace;

public class V1CompositeReferenceModel
extends BaseNamedModel
implements CompositeReferenceModel {
    private List<BindingModel> _bindings = new ArrayList<BindingModel>();
    private InterfaceModel _interface;

    public V1CompositeReferenceModel() {
        super(SCANamespace.DEFAULT.uri(), "reference");
        this.setMultiplicity("1..1");
    }

    public V1CompositeReferenceModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration binding_config : config.getChildrenStartsWith("binding")) {
            BindingModel binding = (BindingModel)this.readModel(binding_config);
            if (binding == null) continue;
            this._bindings.add(binding);
        }
    }

    @Override
    public CompositeModel getComposite() {
        return (CompositeModel)this.getModelParent();
    }

    @Override
    public List<ComponentReferenceModel> getComponentReferences() {
        ArrayList<ComponentReferenceModel> list = new ArrayList<ComponentReferenceModel>();
        CompositeModel composite = this.getComposite();
        if (composite != null) {
            String[] promotes;
            for (String promote : promotes = Strings.splitTrimToNullArray((String)this.getPromote(), (String)" ")) {
                String[] names = Strings.splitTrimToNullArray((String)promote, (String)"/");
                int namesCount = names.length;
                if (namesCount <= 0) continue;
                String componentName = names[0];
                String componentReferenceName = namesCount == 2 ? names[1] : null;
                boolean componentMissing = true;
                block1: for (ComponentModel component : composite.getComponents()) {
                    if (!componentName.equals(component.getName())) continue;
                    List<ComponentReferenceModel> componentReferences = component.getReferences();
                    if (namesCount == 1) {
                        ComponentReferenceModel componentReference;
                        if (componentReferences.size() <= 0 || (componentReference = componentReferences.iterator().next()) == null) continue;
                        list.add(componentReference);
                        componentMissing = false;
                        break;
                    }
                    if (namesCount != 2) continue;
                    for (ComponentReferenceModel componentReference : componentReferences) {
                        if (!componentReferenceName.equals(componentReference.getName())) continue;
                        list.add(componentReference);
                        componentMissing = false;
                        break block1;
                    }
                }
                if (!componentMissing) continue;
                ConfigLogger.ROOT_LOGGER.missingComponentReference(componentReferenceName != null ? componentReferenceName : "", componentName);
            }
        }
        return list;
    }

    @Override
    public String getPromote() {
        return this.getModelAttribute("promote");
    }

    @Override
    public CompositeReferenceModel setPromote(String promote) {
        this.setModelAttribute("promote", promote);
        return this;
    }

    @Override
    public String getMultiplicity() {
        return this.getModelAttribute("multiplicity");
    }

    @Override
    public CompositeReferenceModel setMultiplicity(String multiplicity) {
        this.setModelAttribute("multiplicity", multiplicity);
        return this;
    }

    @Override
    public synchronized List<BindingModel> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    @Override
    public synchronized CompositeReferenceModel addBinding(BindingModel binding) {
        this.addChildModel(binding);
        this._bindings.add(binding);
        return this;
    }

    @Override
    public InterfaceModel getInterface() {
        if (this._interface == null) {
            this._interface = (InterfaceModel)this.getFirstChildModelStartsWith("interface");
        }
        return this._interface;
    }

    @Override
    public CompositeReferenceModel setInterface(InterfaceModel interfaze) {
        this.setChildModel(interfaze);
        this._interface = interfaze;
        return this;
    }
}

