/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model;

import java.io.Serializable;
import org.switchyard.config.model.Descriptor;

public interface Namespace
extends Serializable {
    public String section();

    public String version();

    public boolean versionMatches(Namespace var1);

    public String uri();

    public boolean uriMatches(Namespace var1);

    public boolean isDefault();

    public static abstract class Util
    implements Namespace {
        private final String _section;
        private final String _version;
        private final String _uri;

        protected Util(Descriptor descriptor, String section, String version) {
            this._section = section;
            if (version != null) {
                this._version = version;
                this._uri = descriptor.getNamespace(this._section, this._version);
            } else {
                this._uri = descriptor.getDefaultNamespace(this._section);
                this._version = Util.extractVersion(this._uri);
            }
        }

        @Override
        public String section() {
            return this._section;
        }

        @Override
        public String version() {
            return this._version;
        }

        @Override
        public boolean versionMatches(Namespace namespace) {
            String version;
            String string = version = namespace != null ? namespace.version() : null;
            return version != null ? version.equals(this._version) : this._version == null;
        }

        @Override
        public String uri() {
            return this._uri;
        }

        @Override
        public boolean uriMatches(Namespace namespace) {
            String uri;
            String string = uri = namespace != null ? namespace.uri() : null;
            return uri != null ? uri.equals(this._uri) : this._uri == null;
        }

        @Override
        public boolean isDefault() {
            return false;
        }

        public static String extractVersion(String uri) {
            int pos;
            if (uri != null && (pos = uri.lastIndexOf(58)) > -1) {
                return uri.substring(pos + 1, uri.length());
            }
            return null;
        }

        public static <N extends Namespace> N fromUri(Class<N> enumType, String uri) {
            Namespace[] ns;
            if (uri != null && (ns = (Namespace[])enumType.getEnumConstants()) != null) {
                for (Namespace n : ns) {
                    if (!n.uri().equals(uri)) continue;
                    return (N)n;
                }
            }
            return null;
        }
    }
}

