/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Models;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;

public class MergeScanner<M extends Model>
implements Scanner<M> {
    private final boolean _fromOverridesTo;
    private final List<Scanner<M>> _scanners;

    public MergeScanner(boolean fromOverridesTo, Scanner<M> ... scanners) {
        this._fromOverridesTo = fromOverridesTo;
        ArrayList<Scanner<M>> list = new ArrayList<Scanner<M>>();
        if (scanners != null) {
            for (Scanner<M> scanner : scanners) {
                if (scanner == null) continue;
                list.add(scanner);
            }
        }
        this._scanners = list;
    }

    public MergeScanner(boolean fromOverridesTo, List<Scanner<M>> scanners) {
        this._fromOverridesTo = fromOverridesTo;
        this._scanners = new ArrayList<Scanner<M>>();
        if (scanners != null) {
            for (Scanner<M> scanner : scanners) {
                if (scanner == null) continue;
                this._scanners.add(scanner);
            }
        }
    }

    @Override
    public ScannerOutput<M> scan(ScannerInput<M> input) throws IOException {
        Model merged = null;
        for (Scanner<M> scanner : this._scanners) {
            List<M> scanned_list;
            ScannerOutput<M> scannerOutput = scanner.scan(input);
            if (scannerOutput == null || (scanned_list = scannerOutput.getModels()) == null) continue;
            for (Model scanned : scanned_list) {
                if (scanned == null) continue;
                if (merged == null) {
                    merged = scanned;
                    continue;
                }
                merged = Models.merge(scanned, merged, this._fromOverridesTo);
            }
        }
        Configuration config = merged.getModelConfiguration();
        String xmlns_x2 = "xmlns:xmlns";
        if (config.hasAttribute("xmlns:xmlns")) {
            String xmlns = config.getAttribute("xmlns:xmlns");
            config.setAttribute("xmlns:xmlns", null);
            config.setAttribute("xmlns", xmlns);
        }
        return new ScannerOutput<Model>().setModel(merged);
    }
}

