/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model;

import java.net.URI;
import javax.xml.namespace.QName;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.NamedModel;

public abstract class BaseNamedModel
extends BaseModel
implements NamedModel {
    protected static final String TARGET_NAMESPACE = "targetNamespace";

    protected BaseNamedModel(QName qname) {
        super(qname);
    }

    protected BaseNamedModel(String namespace, String name) {
        super(namespace, name);
    }

    protected BaseNamedModel(Configuration config) {
        super(config);
    }

    protected BaseNamedModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public String getName() {
        return this.getModelAttribute("name");
    }

    @Override
    public NamedModel setName(String name) {
        this.setModelAttribute("name", name);
        return this;
    }

    @Override
    public String getTargetNamespace() {
        String tns = null;
        Model model = this;
        while (model instanceof BaseModel && (tns = Strings.trimToNull((String)((BaseModel)model).getModelAttribute(TARGET_NAMESPACE))) == null) {
            model = model.getModelParent();
        }
        return tns;
    }

    @Override
    public URI getTargetNamespaceURI() {
        String tns = this.getTargetNamespace();
        return tns != null ? URI.create(tns) : null;
    }

    @Override
    public QName getQName() {
        return XMLHelper.createQName((String)this.getTargetNamespace(), (String)this.getName());
    }
}

