/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.composite.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.common.property.CompoundPropertyResolver;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.common.property.SystemAndTestPropertyResolver;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseNamedModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.property.PropertyModel;

public class V1ComponentModel
extends BaseNamedModel
implements ComponentModel {
    private ComponentImplementationModel _implementation;
    private List<ComponentServiceModel> _services = new ArrayList<ComponentServiceModel>();
    private List<ComponentReferenceModel> _references = new ArrayList<ComponentReferenceModel>();
    private Map<String, PropertyModel> _properties = new HashMap<String, PropertyModel>();

    public V1ComponentModel() {
        super(new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "component"));
        this.setModelChildrenOrder("implementation.*", "service", "reference", "property");
        this.setComponentPropertyResolver();
    }

    public V1ComponentModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration service_config : config.getChildren("service")) {
            ComponentServiceModel service = (ComponentServiceModel)this.readModel(service_config);
            if (service == null) continue;
            this._services.add(service);
        }
        for (Configuration reference_config : config.getChildren("reference")) {
            ComponentReferenceModel reference = (ComponentReferenceModel)this.readModel(reference_config);
            if (reference == null) continue;
            this._references.add(reference);
        }
        for (Configuration property_config : config.getChildren("property")) {
            PropertyModel property = (PropertyModel)this.readModel(property_config);
            if (property == null) continue;
            this._properties.put(property.getName(), property);
        }
        this.setModelChildrenOrder("implementation.*", "service", "reference", "property");
        this.setComponentPropertyResolver();
    }

    @Override
    public CompositeModel getComposite() {
        return (CompositeModel)this.getModelParent();
    }

    @Override
    public ComponentImplementationModel getImplementation() {
        if (this._implementation == null) {
            this._implementation = (ComponentImplementationModel)this.getFirstChildModelStartsWith("implementation");
        }
        return this._implementation;
    }

    @Override
    public ComponentModel setImplementation(ComponentImplementationModel implementation) {
        this.setChildModel(implementation);
        this._implementation = implementation;
        return this;
    }

    @Override
    public synchronized List<ComponentServiceModel> getServices() {
        return Collections.unmodifiableList(this._services);
    }

    @Override
    public synchronized ComponentModel addService(ComponentServiceModel service) {
        this.addChildModel(service);
        this._services.add(service);
        return this;
    }

    @Override
    public synchronized List<ComponentReferenceModel> getReferences() {
        return Collections.unmodifiableList(this._references);
    }

    @Override
    public synchronized ComponentModel addReference(ComponentReferenceModel reference) {
        this.addChildModel(reference);
        this._references.add(reference);
        return this;
    }

    @Override
    public synchronized PropertyModel getProperty(String name) {
        return this._properties.get(name);
    }

    @Override
    public synchronized Map<String, PropertyModel> getProperties() {
        return Collections.unmodifiableMap(this._properties);
    }

    @Override
    public synchronized V1ComponentModel addProperty(PropertyModel property) {
        this.addChildModel(property);
        this._properties.put(property.getName(), property);
        return this;
    }

    public Object resolveProperty(String key) {
        String value = null;
        if (key != null) {
            PropertyModel property = this.getProperty(key);
            value = property != null ? property.getValue() : null;
        }
        return value;
    }

    @Override
    public void setComponentPropertyResolver() {
        Configuration config = this.getModelConfiguration();
        Configuration parent = config.getParent();
        if (parent != null) {
            config.setPropertyResolver(CompoundPropertyResolver.compact((PropertyResolver[])new PropertyResolver[]{parent.getPropertyResolver(), this}));
        } else {
            config.setPropertyResolver(CompoundPropertyResolver.compact((PropertyResolver[])new PropertyResolver[]{SystemAndTestPropertyResolver.INSTANCE, this}));
        }
    }
}

