/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Models;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;

public class MergeScanner<M extends Model>
implements Scanner<M> {
    private final Class<M> _clazz;
    private final boolean _fromOverridesTo;
    private final List<Scanner<M>> _scanners;

    public MergeScanner(Class<M> clazz, boolean fromOverridesTo, Scanner<M> ... scanners) {
        this._clazz = clazz;
        this._fromOverridesTo = fromOverridesTo;
        ArrayList<Scanner<M>> list = new ArrayList<Scanner<M>>();
        if (scanners != null) {
            for (Scanner scanner : list) {
                if (scanner == null) continue;
                list.add(scanner);
            }
        }
        this._scanners = list;
    }

    public MergeScanner(Class<M> clazz, boolean fromOverridesTo, List<Scanner<M>> scanners) {
        this._clazz = clazz;
        this._fromOverridesTo = fromOverridesTo;
        this._scanners = new ArrayList<Scanner<M>>();
        if (scanners != null) {
            for (Scanner<M> scanner : scanners) {
                if (scanner == null) continue;
                this._scanners.add(scanner);
            }
        }
    }

    @Override
    public ScannerOutput<M> scan(ScannerInput<M> input) throws IOException {
        Model merged;
        try {
            merged = (Model)this._clazz.newInstance();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        for (Scanner<M> scanner : this._scanners) {
            List<M> scanned_list;
            ScannerOutput<M> scannerOutput = scanner.scan(input);
            if (scannerOutput == null || (scanned_list = scannerOutput.getModels()) == null) continue;
            for (Model scanned : scanned_list) {
                if (scanned == null) continue;
                merged = Models.merge(scanned, merged, this._fromOverridesTo);
            }
        }
        return new ScannerOutput<Model>().setModel(merged);
    }
}

