/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.version;

import org.switchyard.common.version.Implementation;
import org.switchyard.common.version.Project;
import org.switchyard.common.version.Specification;
import org.switchyard.common.version.Version;

public class BaseVersion
implements Version {
    private final Project _project;
    private final Specification _specification;
    private final Implementation _implementation;

    public BaseVersion(Project project, Specification specification, Implementation implementation) {
        this._project = project;
        this._specification = specification;
        this._implementation = implementation;
    }

    @Override
    public Project getProject() {
        return this._project;
    }

    @Override
    public Specification getSpecification() {
        return this._specification;
    }

    @Override
    public Implementation getImplementation() {
        return this._implementation;
    }

    public String toString() {
        return String.format("%s: %s, %s, %s", Version.class.getSimpleName(), this.getProject(), this.getSpecification(), this.getImplementation());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseVersion other = (BaseVersion)obj;
        if (this._project == null ? other._project != null : !this._project.equals(other._project)) {
            return false;
        }
        if (this._specification == null ? other._specification != null : !this._specification.equals(other._specification)) {
            return false;
        }
        return !(this._implementation == null ? other._implementation != null : !this._implementation.equals(other._implementation));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._project == null ? 0 : this._project.hashCode());
        result = 31 * result + (this._specification == null ? 0 : this._specification.hashCode());
        result = 31 * result + (this._implementation == null ? 0 : this._implementation.hashCode());
        return result;
    }

    @Override
    public int compareTo(Version that) {
        int comparison = 0;
        if (this != that) {
            if (that == null) {
                comparison = -1;
            } else {
                if (this._project != null) {
                    comparison = this._project.compareTo(that.getProject());
                }
                if (comparison == 0 && this._specification != null) {
                    comparison = this._specification.compareTo(that.getSpecification());
                }
                if (comparison == 0 && this._implementation != null) {
                    comparison = this._implementation.compareTo(that.getImplementation());
                }
            }
        }
        return comparison;
    }

    static int compare(String s1, String s2) {
        if (s1 != null) {
            if (s2 != null) {
                return s1.compareTo(s2);
            }
            return -1;
        }
        if (s2 != null) {
            return 1;
        }
        return 0;
    }
}

