/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.version;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.switchyard.common.version.BaseVersion;
import org.switchyard.common.version.Project;

public class BaseProject
implements Project {
    private final String _groupId;
    private final String _artifactId;
    private final String _packaging;
    private final String _name;
    private final String _description;
    private final URL _url;
    private final URI _uri;
    private final String _version;

    public BaseProject(String groupId, String artifactId, String packaging, String name, String description, URL url, String version) {
        this._groupId = groupId;
        this._artifactId = artifactId;
        this._packaging = packaging;
        this._name = name;
        this._description = description;
        this._url = url;
        this._uri = this.toURI(this._url);
        this._version = version;
    }

    public BaseProject(String groupId, String artifactId, String packaging, String name, String description, String url, String version) {
        this._groupId = groupId;
        this._artifactId = artifactId;
        this._packaging = packaging;
        this._name = name;
        this._description = description;
        this._url = this.toURL(url);
        this._uri = this.toURI(this._url);
        this._version = version;
    }

    @Override
    public String getGroupId() {
        return this._groupId;
    }

    @Override
    public String getArtifactId() {
        return this._artifactId;
    }

    @Override
    public String getPackaging() {
        return this._packaging;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public URL getURL() {
        return this._url;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    public String toString() {
        return String.format("%s [groupId=%s, artifactId=%s, packaging=%s, name=%s, description=%s, url=%s, version=%s]", Project.class.getSimpleName(), this.getGroupId(), this.getArtifactId(), this.getPackaging(), this.getName(), this.getDescription(), this.getURL(), this.getVersion());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseProject other = (BaseProject)obj;
        if (this._groupId == null ? other._groupId != null : !this._groupId.equals(other._groupId)) {
            return false;
        }
        if (this._artifactId == null ? other._artifactId != null : !this._artifactId.equals(other._artifactId)) {
            return false;
        }
        if (this._packaging == null ? other._packaging != null : !this._packaging.equals(other._packaging)) {
            return false;
        }
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        if (this._description == null ? other._description != null : !this._description.equals(other._description)) {
            return false;
        }
        if (this._uri == null ? other._uri != null : !this._uri.equals(other._uri)) {
            return false;
        }
        return !(this._version == null ? other._version != null : !this._version.equals(other._version));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._groupId == null ? 0 : this._groupId.hashCode());
        result = 31 * result + (this._artifactId == null ? 0 : this._artifactId.hashCode());
        result = 31 * result + (this._packaging == null ? 0 : this._packaging.hashCode());
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._description == null ? 0 : this._description.hashCode());
        result = 31 * result + (this._uri == null ? 0 : this._uri.hashCode());
        result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
        return result;
    }

    @Override
    public int compareTo(Project that) {
        int comparison = 0;
        if (this != that && (comparison = BaseVersion.compare(this._groupId, that.getGroupId())) == 0 && (comparison = BaseVersion.compare(this._artifactId, that.getArtifactId())) == 0 && (comparison = BaseVersion.compare(this._packaging, that.getPackaging())) == 0 && (comparison = BaseVersion.compare(this._name, that.getName())) == 0 && (comparison = BaseVersion.compare(this._description, that.getDescription())) == 0 && (comparison = BaseVersion.compare(this.toString(this._url), this.toString(that.getURL()))) == 0) {
            comparison = BaseVersion.compare(this._version, that.getVersion());
        }
        return comparison;
    }

    private URI toURI(URL url) {
        if (url != null) {
            try {
                return url.toURI();
            }
            catch (URISyntaxException usi) {
                return null;
            }
        }
        return null;
    }

    private URL toURL(String url) {
        if (url != null) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException mue) {
                return null;
            }
        }
        return null;
    }

    private String toString(URL url) {
        return url != null ? url.toString() : null;
    }
}

