/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.version;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.switchyard.common.version.BaseVersion;
import org.switchyard.common.version.Implementation;

public class BaseImplementation
implements Implementation {
    private final String _title;
    private final String _vendor;
    private final String _vendorId;
    private final URL _url;
    private final URI _uri;
    private final String _version;

    public BaseImplementation(String title, String vendor, String vendorId, URL url, String version) {
        this._title = title;
        this._vendor = vendor;
        this._vendorId = vendorId;
        this._url = url;
        this._uri = this.toURI(this._url);
        this._version = version;
    }

    public BaseImplementation(String title, String vendor, String vendorId, String url, String version) {
        this._title = title;
        this._vendor = vendor;
        this._vendorId = vendorId;
        this._url = this.toURL(url);
        this._uri = this.toURI(this._url);
        this._version = version;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public String getVendor() {
        return this._vendor;
    }

    @Override
    public String getVendorId() {
        return this._vendorId;
    }

    @Override
    public URL getURL() {
        return this._url;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    public String toString() {
        return String.format("%s [title=%s, vendor=%s, vendorId=%s, url=%s, version=%s]", Implementation.class.getSimpleName(), this.getTitle(), this.getVendor(), this.getVendorId(), this.getURL(), this.getVersion());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseImplementation other = (BaseImplementation)obj;
        if (this._title == null ? other._title != null : !this._title.equals(other._title)) {
            return false;
        }
        if (this._vendor == null ? other._vendor != null : !this._vendor.equals(other._vendor)) {
            return false;
        }
        if (this._vendorId == null ? other._vendorId != null : !this._vendorId.equals(other._vendorId)) {
            return false;
        }
        if (this._uri == null ? other._uri != null : !this._uri.equals(other._uri)) {
            return false;
        }
        return !(this._version == null ? other._version != null : !this._version.equals(other._version));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._title == null ? 0 : this._title.hashCode());
        result = 31 * result + (this._vendor == null ? 0 : this._vendor.hashCode());
        result = 31 * result + (this._vendorId == null ? 0 : this._vendorId.hashCode());
        result = 31 * result + (this._uri == null ? 0 : this._uri.hashCode());
        result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
        return result;
    }

    @Override
    public int compareTo(Implementation that) {
        int comparison = 0;
        if (this != that && (comparison = BaseVersion.compare(this._title, that.getTitle())) == 0 && (comparison = BaseVersion.compare(this._vendor, that.getVendor())) == 0 && (comparison = BaseVersion.compare(this._vendorId, that.getVendorId())) == 0 && (comparison = BaseVersion.compare(this.toString(this._url), this.toString(that.getURL()))) == 0) {
            comparison = BaseVersion.compare(this._version, that.getVersion());
        }
        return comparison;
    }

    private URI toURI(URL url) {
        if (url != null) {
            try {
                return url.toURI();
            }
            catch (URISyntaxException usi) {
                return null;
            }
        }
        return null;
    }

    private URL toURL(String url) {
        if (url != null) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException mue) {
                return null;
            }
        }
        return null;
    }

    private String toString(URL url) {
        return url != null ? url.toString() : null;
    }
}

