/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.io.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.type.Classes;

public abstract class BaseResource
implements Resource {
    @Override
    public URL getLocationURL() {
        return this.getLocationURL(this.getClass());
    }

    @Override
    public URL getLocationURL(Class<?> caller) {
        return BaseResource.getURL(this.getLocation(), caller);
    }

    @Override
    public URL getLocationURL(ClassLoader loader) {
        return BaseResource.getURL(this.getLocation(), loader);
    }

    public static final URL getURL(String location, Class<?> caller) {
        return BaseResource.getURL(location, caller, null);
    }

    public static final URL getURL(String location, ClassLoader loader) {
        return BaseResource.getURL(location, null, loader);
    }

    private static final URL getURL(String location, Class<?> caller, ClassLoader loader) {
        if (location != null) {
            try {
                if (location.startsWith("http:") || location.startsWith("https:")) {
                    return new URL(location);
                }
                if (location.startsWith("file:")) {
                    return new File(location.substring(5)).toURI().toURL();
                }
                if (caller != null) {
                    return Classes.getResource(location, caller);
                }
                if (loader != null) {
                    return Classes.getResource(location, loader);
                }
                return Classes.getResource(location, BaseResource.class);
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return null;
    }
}

