/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.version.manifest;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;
import org.switchyard.common.type.Classes;
import org.switchyard.common.version.BaseVersionFactory;
import org.switchyard.common.version.Query;
import org.switchyard.common.version.Version;
import org.switchyard.common.version.manifest.ManifestVersion;

public final class ManifestVersionFactory
extends BaseVersionFactory {
    private static final Logger LOGGER = Logger.getLogger(ManifestVersionFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public Set<Version> getVersions(boolean returnFirstOnly, Query ... queries) {
        List<Object> urls;
        try {
            urls = Classes.getResources("META-INF/MANIFEST.MF", this.getClass());
        }
        catch (IOException ioe) {
            urls = Collections.emptyList();
        }
        TreeSet<Version> versions = new TreeSet<Version>();
        for (URL url : urls) {
            InputStream is;
            block17: {
                is = null;
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                is = conn.getInputStream();
                ManifestVersion version = new ManifestVersion(new Manifest(is));
                boolean matches = true;
                for (Query query : queries) {
                    if (query.matches(version)) continue;
                    matches = false;
                    break;
                }
                if (!matches) break block17;
                versions.add(version);
                if (!returnFirstOnly) break block17;
                if (is == null) break;
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    LOGGER.warn((Object)String.format("problem closing %s stream: %s", url, ioe.getMessage()));
                }
                break;
            }
            if (is == null) continue;
            try {
                is.close();
            }
            catch (IOException ioe) {
                LOGGER.warn((Object)String.format("problem closing %s stream: %s", url, ioe.getMessage()));
            }
            continue;
            catch (IOException ioe) {
                try {
                    LOGGER.warn((Object)String.format("problem reading %s stream: %s", url, ioe.getMessage()));
                    if (is == null) continue;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ioe2) {
                            LOGGER.warn((Object)String.format("problem closing %s stream: %s", url, ioe2.getMessage()));
                        }
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException ioe3) {
                    LOGGER.warn((Object)String.format("problem closing %s stream: %s", url, ioe3.getMessage()));
                }
            }
        }
        return versions;
    }
}

