/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.property;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.switchyard.common.property.PropertyResolver;

public final class SystemPropertyResolver
implements PropertyResolver {
    public static final SystemPropertyResolver INSTANCE = new SystemPropertyResolver();

    private SystemPropertyResolver() {
    }

    @Override
    public final Object resolveProperty(final String key) {
        return key != null ? AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String value = System.getProperty(key);
                if (value == null && key.startsWith("env.")) {
                    value = System.getenv(key.substring(4));
                }
                return value;
            }
        }) : null;
    }
}

