/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.codec;

import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;

public final class Base64 {
    public static final String encode(byte[] bytes) {
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    public static final String encodeFromString(String value) {
        return Base64.encodeFromString(value, Charset.defaultCharset());
    }

    public static final String encodeFromString(String value, String charsetName) {
        return Base64.encodeFromString(value, Charset.forName(charsetName));
    }

    public static final String encodeFromString(String value, Charset charset) {
        return Base64.encode(value.getBytes(charset));
    }

    public static final byte[] decode(String encoded) {
        return DatatypeConverter.parseBase64Binary((String)encoded);
    }

    public static final String decodeToString(String encoded) {
        return Base64.decodeToString(encoded, Charset.defaultCharset());
    }

    public static final String decodeToString(String encoded, String charsetName) {
        return Base64.decodeToString(encoded, Charset.forName(charsetName));
    }

    public static final String decodeToString(String encoded, Charset charset) {
        return new String(Base64.decode(encoded), charset);
    }

    private Base64() {
    }
}

