/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.switchyard.common.xml.Node;
import org.xml.sax.Attributes;

public class Element
implements Node {
    private static final Comparator<QName> QNAME_COMPARATOR = new QNameComparator();
    private final QName _name;
    private final Map<QName, String> _attributes = new TreeMap<QName, String>(QNAME_COMPARATOR);
    private final List<Node> _children = new ArrayList<Node>();

    Element(String namespaceURI, String localName, Attributes attributes) {
        this._name = new QName(namespaceURI, localName);
        int numAttributes = attributes.getLength();
        for (int count = 0; count < numAttributes; ++count) {
            String attrNamespaceURI = attributes.getURI(count);
            String attrLocalName = attributes.getLocalName(count);
            String attrValue = attributes.getValue(count);
            this._attributes.put(new QName(attrNamespaceURI, attrLocalName), attrValue);
        }
    }

    void addChild(Node child) {
        this._children.add(child);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Element) {
            Element rhs = (Element)obj;
            return this._name.equals(rhs._name) && ((Object)this._attributes).equals(rhs._attributes) && ((Object)this._children).equals(rhs._children);
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode() ^ ((Object)this._attributes).hashCode() ^ ((Object)this._children).hashCode();
    }

    private static final class QNameComparator
    implements Comparator<QName>,
    Serializable {
        private static final long serialVersionUID = -8711685004148549433L;

        private QNameComparator() {
        }

        @Override
        public int compare(QName name1, QName name2) {
            int uriComparator = name1.getNamespaceURI().compareTo(name2.getNamespaceURI());
            if (uriComparator != 0) {
                return uriComparator;
            }
            return name1.getLocalPart().compareTo(name2.getLocalPart());
        }
    }
}

