/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.io;

import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends OutputStream {
    private final OutputStream _out;
    private int _count;

    public CountingOutputStream(OutputStream out) {
        this._out = out;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this._out.write(b);
        this._count += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this._out.write(b, off, len);
        this._count += len;
    }

    @Override
    public void write(int b) throws IOException {
        this._out.write(b);
        ++this._count;
    }

    @Override
    public void flush() throws IOException {
        this._out.flush();
    }

    @Override
    public void close() throws IOException {
        this._out.close();
    }

    public int getCount() {
        return this._count;
    }
}

