/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.camel;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ManagementStatisticsLevel;
import org.switchyard.ServiceDomain;
import org.switchyard.common.camel.CommonCamelLogger;
import org.switchyard.common.type.Classes;

public final class CamelContextConfigurator {
    public static final String SHUTDOWN_TIMEOUT = "org.switchyard.camel.ShutdownTimeout";
    public static final String PERFORMANCE_STATISTICS = "org.switchyard.camel.PerformanceStatistics";
    public static final String CAMEL_CONTEXT_CONFIG = "org.switchyard.camel.CamelContextConfiguration";

    private CamelContextConfigurator() {
    }

    public static final void configure(CamelContext context, ServiceDomain domain) {
        CamelContextConfigurator.configure(context, domain.getProperties());
    }

    public static final void configure(CamelContext context, Map<String, Object> properties) {
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            if (property.getValue() == null) continue;
            CamelContextConfigurator.configure(context, property.getKey(), property.getValue());
        }
    }

    public static final void configure(CamelContext context, String name, Object value) {
        try {
            if (name.equals(SHUTDOWN_TIMEOUT)) {
                CamelContextConfigurator.configureShutdownTimeout(context, value);
            } else if (name.equals(PERFORMANCE_STATISTICS)) {
                CamelContextConfigurator.configurePerformanceStatistics(context, value);
            } else if (name.equals(CAMEL_CONTEXT_CONFIG)) {
                CamelContextConfigurator.configureCamelContextAware(context, value);
            }
        }
        catch (Exception ex) {
            CommonCamelLogger.ROOT_LOGGER.camelContextConfigurationError(name, value, ex);
        }
    }

    private static void configureShutdownTimeout(CamelContext context, Object value) {
        int timeout = Integer.parseInt(value.toString());
        context.getShutdownStrategy().setTimeout((long)timeout);
    }

    private static void configurePerformanceStatistics(CamelContext context, Object value) {
        ManagementStatisticsLevel level = ManagementStatisticsLevel.valueOf((String)value.toString());
        context.getManagementStrategy().setStatisticsLevel(level);
    }

    private static void configureCamelContextAware(CamelContext context, Object value) throws Exception {
        Class contextAwareClass = Classes.forName((String)value.toString());
        CamelContextAware contextAware = (CamelContextAware)contextAwareClass.newInstance();
        contextAware.setCamelContext(context);
    }
}

