/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.camel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.component.cdi.CdiBeanRegistry;
import org.apache.camel.component.cdi.CdiInjector;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.log4j.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.common.camel.event.CamelEventBridge;
import org.switchyard.common.cdi.CDIUtil;

public class SwitchYardCamelContext
extends DefaultCamelContext {
    public static final String CAMEL_CONTEXT_PROPERTY = "CamelContextProperty";
    private final SimpleRegistry _writeableRegistry = new SimpleRegistry();
    private ServiceDomain _domain;
    private Logger _logger = Logger.getLogger(SwitchYardCamelContext.class);
    private AtomicInteger _count = new AtomicInteger();
    private boolean _cdiIntegration;

    public SwitchYardCamelContext() {
        this(true);
    }

    public SwitchYardCamelContext(boolean autoDetectCdi) {
        this._cdiIntegration = autoDetectCdi;
        if (this.isEnableCdiIntegration()) {
            this.setInjector((Injector)new CdiInjector(this.getInjector()));
        } else {
            this._logger.warn((Object)"CDI environment not detected, disabling Camel CDI integration");
        }
        this.getManagementStrategy().addEventNotifier((EventNotifier)new CamelEventBridge());
    }

    public void setServiceDomain(ServiceDomain domain) {
        this._domain = domain;
        for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
            if (!(notifier instanceof CamelEventBridge)) continue;
            ((CamelEventBridge)notifier).setEventPublisher(domain.getEventPublisher());
        }
        PackageScanClassResolver packageScanClassResolver = this.getPackageScanClassResolver();
        if (packageScanClassResolver != null) {
            this.setPackageScanClassResolver(packageScanClassResolver);
        }
        this._domain.getProperties().put(CAMEL_CONTEXT_PROPERTY, this);
    }

    public SimpleRegistry getWritebleRegistry() {
        return this._writeableRegistry;
    }

    public PackageScanClassResolver getPackageScanClassResolver() {
        ServiceLoader<PackageScanClassResolver> resolverLoaders = ServiceLoader.load(PackageScanClassResolver.class, ((Object)((Object)this)).getClass().getClassLoader());
        Iterator<PackageScanClassResolver> i$ = resolverLoaders.iterator();
        if (i$.hasNext()) {
            PackageScanClassResolver packageScanClassResolver = i$.next();
            return packageScanClassResolver;
        }
        return null;
    }

    protected CompositeRegistry createRegistry() {
        ServiceLoader<Registry> registriesLoaders = ServiceLoader.load(Registry.class, ((Object)((Object)this)).getClass().getClassLoader());
        ArrayList<Object> registries = new ArrayList<Object>();
        registries.add(new JndiRegistry());
        if (this.isEnableCdiIntegration()) {
            registries.add(new CdiBeanRegistry());
        }
        registries.add(this._writeableRegistry);
        for (Registry registry : registriesLoaders) {
            registries.add(registry);
        }
        return new CompositeRegistry(registries);
    }

    public ServiceDomain getServiceDomain() {
        return this._domain;
    }

    public boolean isEnableCdiIntegration() {
        if (!this._cdiIntegration) {
            return false;
        }
        return CDIUtil.lookupBeanManager() != null;
    }

    public void start() throws Exception {
        if (this._count.incrementAndGet() == 1) {
            super.start();
        }
    }

    public void stop() throws Exception {
        if (this._count.decrementAndGet() == 0) {
            super.stop();
        }
    }
}

