/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.rules.interview;

import java.io.StringReader;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.switchyard.annotations.Transformer;
import org.switchyard.quickstarts.rules.interview.Applicant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Transformers {
    @Transformer(from="{urn:switchyard-quickstart:rules-interview-container:0.1.0}verify")
    public Applicant transformVerifyToApplicant(Element e) {
        String name = this.getElementValue(e, "name");
        int age = Integer.valueOf(this.getElementValue(e, "age"));
        return new Applicant(name, age);
    }

    @Transformer(to="{urn:switchyard-quickstart:rules-interview-container:0.1.0}verifyResponse")
    public Element transformBooleanToVerifyResponse(boolean b) {
        String xml = "<urn:verifyResponse xmlns:urn='urn:switchyard-quickstart:rules-interview-container:0.1.0'>" + "<return>" + b + "</return>" + "</urn:verifyResponse>";
        return this.toElement(xml);
    }

    private String getElementValue(Element parent, String elementName) {
        String value = null;
        NodeList nodes = parent.getElementsByTagName(elementName);
        if (nodes.getLength() > 0) {
            value = nodes.item(0).getChildNodes().item(0).getNodeValue();
        }
        return value;
    }

    private Element toElement(String xml) {
        DOMResult dom = new DOMResult();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new StreamSource(new StringReader(xml)), dom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((Document)dom.getNode()).getDocumentElement();
    }
}

