/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.jms.binding;

import java.io.IOException;
import java.io.InputStream;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.milyn.io.StreamUtils;

public final class ClientUtil {
    private ClientUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileContent(String fileName) throws Exception {
        InputStream in = null;
        try {
            in = ClientUtil.class.getResourceAsStream(fileName);
            String string = StreamUtils.readStreamAsString((InputStream)in);
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeSession(Session session) {
        try {
            if (session != null) {
                session.close();
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public static void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public static void closeConnectionFactory(HornetQConnectionFactory factory) {
        if (factory != null) {
            factory.close();
        }
    }

    public static void closeContext(Context context) {
        if (context == null) {
            return;
        }
        try {
            context.close();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

