/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.soap.binding.rpc;

import org.switchyard.Exchange;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.component.soap.composer.SOAPBindingData;
import org.switchyard.component.soap.composer.SOAPMessageComposer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CustomComposer
extends SOAPMessageComposer {
    public SOAPBindingData decompose(Exchange exchange, SOAPBindingData target) throws Exception {
        Element messageElement = (Element)exchange.getMessage().getContent(Element.class);
        String response = this.getElementValue(messageElement, "return");
        if (response.contains("500")) {
            exchange.getContext().setProperty("http_response_status", (Object)500).addLabels(new String[]{EndpointLabel.HTTP.label()});
        }
        target = super.decompose(exchange, target);
        return target;
    }

    private String getElementValue(Element parent, String elementName) {
        String value = null;
        NodeList nodes = parent.getElementsByTagName(elementName);
        if (nodes.getLength() > 0) {
            value = nodes.item(0).getChildNodes().item(0).getNodeValue();
        }
        return value;
    }
}

