/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.sap.binding;

import javax.inject.Named;
import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.switchyard.quickstarts.camel.sap.binding.bean.FlightConnectionInfo;
import org.switchyard.quickstarts.camel.sap.binding.bean.FlightCustomerInfo;
import org.switchyard.quickstarts.camel.sap.binding.bean.FlightTripRequestInfo;
import org.switchyard.quickstarts.camel.sap.binding.bean.PassengerInfo;

@Named(value="aggregateFlightBookingStrategy")
public class AggregateFlightBookingStrategy
implements AggregationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateFlightBookingStrategy.class);

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        Exchange answer = oldExchange == null ? newExchange : oldExchange;
        Object payload = answer.getIn().getBody();
        FlightTripRequestInfo flightTripRequestInfo = payload instanceof FlightTripRequestInfo ? (FlightTripRequestInfo)FlightTripRequestInfo.class.cast(payload) : new FlightTripRequestInfo();
        String to = (String)newExchange.getProperty("CamelToEndpoint", String.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("To endpoint = {}", (Object)to);
        }
        if (to.contains("FlightConnectionInfo")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding Flight Connection Info to exchange.");
            }
            flightTripRequestInfo.setFlightConnectionInfo((FlightConnectionInfo)newExchange.getIn().getBody(FlightConnectionInfo.class));
        } else if (to.contains("FlightCustomerInfo")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding Flight Customer Info to exchange.");
            }
            flightTripRequestInfo.setFlightCustomerInfo((FlightCustomerInfo)newExchange.getIn().getBody(FlightCustomerInfo.class));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding Passenger Info to exchange.");
            }
            flightTripRequestInfo.setPassengerInfo((PassengerInfo)newExchange.getIn().getBody(PassengerInfo.class));
        }
        answer.getIn().setBody((Object)flightTripRequestInfo);
        return answer;
    }
}

