/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.cxf;

import java.io.StringReader;
import javax.inject.Named;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.switchyard.annotations.Transformer;
import org.switchyard.quickstarts.camel.cxf.Order;
import org.switchyard.quickstarts.camel.cxf.OrderResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Named(value="Transformers")
public class ServiceTransformers {
    @Transformer(from="{urn:switchyard-quickstart:camel-cxf:2.0}order")
    public Order transformToOrder(Element from) {
        Order order = new Order();
        order.setItem(this.getElementValue(from, "item"));
        order.setQuantity(Integer.valueOf(this.getElementValue(from, "quantity")));
        return order;
    }

    @Transformer(from="{urn:switchyard-quickstart:camel-cxf:2.0}orderResponse")
    public OrderResponse transformToOrderResponse(Element from) {
        OrderResponse orderAck = new OrderResponse();
        orderAck.setReturn(this.getElementValue(from, "return"));
        return orderAck;
    }

    @Transformer(to="{urn:switchyard-quickstart:camel-cxf:2.0}orderResponse")
    public Element transformFromOrderResponse(OrderResponse orderAck) {
        StringBuffer ackXml = new StringBuffer().append("<orderResponse xmlns=\"urn:switchyard-quickstart:camel-cxf:2.0\">").append("<return>").append(orderAck.getReturn()).append("</return>").append("</orderResponse>");
        return this.toElement(ackXml.toString());
    }

    @Transformer(to="{urn:switchyard-quickstart:camel-cxf:2.0}order")
    public Element transformFromOrder(Order order) {
        StringBuffer ackXml = new StringBuffer().append("<orders:order xmlns:orders=\"urn:switchyard-quickstart:camel-cxf:2.0\">").append("<item>" + order.getItem() + "</item>").append("<quantity>" + order.getQuantity() + "</quantity>").append("</orders:order>");
        return this.toElement(ackXml.toString());
    }

    private String getElementValue(Element parent, String elementName) {
        String value = null;
        NodeList nodes = parent.getElementsByTagName(elementName);
        if (nodes.getLength() > 0) {
            value = nodes.item(0).getChildNodes().item(0).getNodeValue();
        }
        return value;
    }

    private Element toElement(String xml) {
        DOMResult dom = new DOMResult();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new StreamSource(new StringReader(xml)), dom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((Document)dom.getNode()).getDocumentElement();
    }
}

