/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demos.orders;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.demos.orders.InventoryService;
import org.switchyard.quickstarts.demos.orders.Item;
import org.switchyard.quickstarts.demos.orders.ItemNotFoundException;
import org.switchyard.quickstarts.demos.orders.Order;
import org.switchyard.quickstarts.demos.orders.OrderAck;
import org.switchyard.quickstarts.demos.orders.OrderService;

@Service(value=OrderService.class)
@ApplicationScoped
public class OrderServiceBean
implements OrderService {
    @Inject
    @Reference
    private InventoryService _inventory;

    public OrderAck submitOrder(Order order) {
        OrderAck orderAck = new OrderAck().setOrderId(order.getOrderId());
        try {
            Item orderItem = this._inventory.lookupItem(order.getItemId());
            if (orderItem.getQuantity() >= order.getQuantity()) {
                orderAck.setAccepted(true).setStatus("Order Accepted");
            } else {
                orderAck.setAccepted(false).setStatus("Insufficient Quantity");
            }
        }
        catch (ItemNotFoundException infEx) {
            orderAck.setAccepted(false).setStatus("Item Not Available");
        }
        return orderAck;
    }
}

